"use strict";function default_1(){return RedisSingleton.getInstance()}var __importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0});exports.redlock=exports.redisClient=exports.RedlockSingleton=exports.RedisSingleton=void 0;exports.default=default_1;const ioredis_1=require("ioredis"),redlock_1=__importDefault(require("redlock")),console_1=require("./console");class RedisSingleton{constructor(){}static getInstance(){if(!RedisSingleton.instance){if(RedisSingleton.isConnecting)return new Promise(e=>{const n=()=>{RedisSingleton.instance?e(RedisSingleton.instance):setTimeout(n,10)};n()});RedisSingleton.isConnecting=!0;try{RedisSingleton.instance=new ioredis_1.Redis({host:process.env.REDIS_HOST||"localhost",port:parseInt(process.env.REDIS_PORT||"6379"),password:process.env.REDIS_PASSWORD,db:parseInt(process.env.REDIS_DB||"0"),maxRetriesPerRequest:3,enableReadyCheck:!0,connectTimeout:5e3,commandTimeout:5e3,lazyConnect:!0,family:4,keepAlive:3e4});RedisSingleton.instance.on("error",e=>{console_1.logger.error("REDIS",`✗ Error: ${e.message}`)})}catch(e){console_1.logger.error("REDIS",`Failed to create Redis instance: ${e}`);throw e}finally{RedisSingleton.isConnecting=!1}}return RedisSingleton.instance}static async safeGet(e,n=3e3){const t=this.getInstance();return Promise.race([t.get(e),new Promise((e,t)=>setTimeout(()=>t(new Error("Redis GET timeout")),n))]).catch(n=>{console_1.logger.error("REDIS",`GET error for key ${e}: ${n}`);return null})}static async safeSet(e,n,t=3e3){const o=this.getInstance();return Promise.race([o.set(e,n).then(()=>!0),new Promise((e,n)=>setTimeout(()=>n(new Error("Redis SET timeout")),t))]).catch(n=>{console_1.logger.error("REDIS",`SET error for key ${e}: ${n}`);return!1})}static async cleanup(){if(RedisSingleton.instance){try{await RedisSingleton.instance.quit()}catch(e){console_1.logger.error("REDIS",`Error during cleanup: ${e}`)}RedisSingleton.instance=null}}}exports.RedisSingleton=RedisSingleton;RedisSingleton.isConnecting=!1;class RedlockSingleton{constructor(){}static getInstance(){if(!RedlockSingleton.instance){const e=RedisSingleton.getInstance();RedlockSingleton.instance=new redlock_1.default([e],{driftFactor:.01,retryCount:10,retryDelay:200,retryJitter:200,automaticExtensionThreshold:500});RedlockSingleton.instance.on("error",e=>{console_1.logger.error("REDLOCK",`Error: ${e.message}`)})}return RedlockSingleton.instance}}exports.RedlockSingleton=RedlockSingleton;exports.redisClient=RedisSingleton.getInstance();exports.redlock=RedlockSingleton.getInstance();