"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.CacheManager=void 0;const db_1=require("@b/db"),redis_1=require("./redis"),console_1=require("./console"),redis=redis_1.RedisSingleton.getInstance();class CacheManager{constructor(){this.settingsKey="settings";this.extensionsKey="extensions";this.settings=new Map;this.extensions=new Map}static getInstance(){CacheManager.instance||(CacheManager.instance=new CacheManager);return CacheManager.instance}async getSettings(){if(0===this.settings.size)try{const e=await this.getCache(this.settingsKey);Object.keys(e).length>0?this.settings=new Map(Object.entries(e)):await this.loadSettingsFromDB()}catch(e){console_1.logger.error("CACHE",`Failed to load settings: ${e.message}`,e);throw e}return this.settings}async getExtensions(){if(0===this.extensions.size)try{const e=await this.getCache(this.extensionsKey);Object.keys(e).length>0?this.extensions=new Map(Object.entries(e)):await this.loadExtensionsFromDB()}catch(e){console_1.logger.error("CACHE",`Failed to load extensions: ${e.message}`,e);throw e}return this.extensions}async getSetting(e){return(await this.getSettings()).get(e)}async updateSetting(e,t,s=!1){0===this.settings.size&&await this.getSettings();this.settings.set(e,t);await redis.hset(this.settingsKey,e,JSON.stringify(t));s&&await db_1.models.settings.upsert({key:e,value:t})}async updateExtension(e,t,s=!1){0===this.extensions.size&&await this.getExtensions();this.extensions.set(e,t);await redis.hset(this.extensionsKey,e,JSON.stringify(t));s&&await db_1.models.extension.upsert({name:e,...t})}async loadSettingsFromDB(){const e=await db_1.models.settings.findAll(),t=redis.pipeline();e.forEach(e=>{this.settings.set(e.key,e.value);t.hset(this.settingsKey,e.key,JSON.stringify(e.value))});await t.exec()}async loadExtensionsFromDB(){const e=await db_1.models.extension.findAll({where:{status:!0}}),t=redis.pipeline();e.forEach(e=>{this.extensions.set(e.name,e);t.hset(this.extensionsKey,e.name,JSON.stringify(e))});await t.exec()}async getCache(e){const t=await redis.hgetall(e);return Object.keys(t).reduce((e,s)=>{e[s]=JSON.parse(t[s]);return e},{})}async clearCache(){try{this.settings.clear();this.extensions.clear();await redis.del(this.settingsKey,this.extensionsKey);await this.loadSettingsFromDB();await this.loadExtensionsFromDB()}catch(e){console_1.logger.error("CACHE",`Cache clear and reload failed: ${e.message}`,e);throw e}}}exports.CacheManager=CacheManager;