"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.deepseekClient=exports.DeepSeekClient=void 0;const console_1=require("@b/utils/console"),error_1=require("@b/utils/error");class DeepSeekClient{constructor(){this.baseUrl="https://api.deepseek.com/v1";this.apiKey=process.env.DEEPSEEK_API_KEY||"";this.apiKey||console_1.logger.error("DEEPSEEK","API key is not set")}async generateText(e,t={}){if(!this.apiKey)throw(0,error_1.createError)({statusCode:500,message:"DeepSeek API key is not set"});const{model:n="deepseek-chat",temperature:r=.7,max_tokens:s=1e3,top_p:o=.95}=t;try{const t=await fetch(`${this.baseUrl}/chat/completions`,{method:"POST",headers:{"Content-Type":"application/json",Authorization:`Bearer ${this.apiKey}`},body:JSON.stringify({model:n,messages:[{role:"user",content:e}],temperature:r,max_tokens:s,top_p:o})});if(!t.ok){let e;try{e=await t.json()}catch(n){e=await t.text()}throw(0,error_1.createError)({statusCode:500,message:`DeepSeek API error: ${e&&(e.message||e)||t.statusText}`})}return(await t.json()).choices[0].message.content}catch(e){console_1.logger.error("DEEPSEEK","Error generating text",e);throw e}}async generateFAQ(e,t){const n=`\n      Generate a comprehensive FAQ about "${e}".\n      ${t?`Consider this context: ${t}`:""}\n      \n      Format the response as a JSON object with the following structure:\n      {\n        "question": "The question text",\n        "answer": "The detailed answer",\n        "tags": ["tag1", "tag2"]\n      }\n    `,r=await this.generateText(n,{temperature:.7,max_tokens:1500});try{return JSON.parse(r)}catch(t){console_1.logger.error("DEEPSEEK","Failed to parse response as JSON",t);return{question:e,answer:r,tags:[]}}}async improveFAQ(e,t){const n=`\n      Improve the following FAQ answer to make it more comprehensive, clear, and helpful:\n      \n      Question: ${e}\n      Current Answer: ${t}\n      \n      Provide only the improved answer text without any additional commentary.\n    `;return await this.generateText(n,{temperature:.7,max_tokens:1500})}async answerQuestion(e,t){const n=`\n      Based on the following existing FAQs:\n      \n      ${t.map(e=>`Q: ${e.question}\nA: ${e.answer}`).join("\n\n")}\n      \n      Answer this user question: "${e}"\n      \n      If the question is not directly addressed in the existing FAQs, use the information provided to give the best possible answer.\n      If you cannot answer the question based on the provided FAQs, respond with "I don't have enough information to answer this question."\n    `;return await this.generateText(n,{temperature:.5,max_tokens:1e3})}async suggestTags(e,t){const n=`\n      Suggest 3-5 relevant tags for the following FAQ:\n      \n      Question: ${e}\n      Answer: ${t}\n      \n      Return only a JSON array of tag strings, for example: ["tag1", "tag2", "tag3"]\n    `,r=await this.generateText(n,{temperature:.5,max_tokens:200});try{return JSON.parse(r)}catch(e){console_1.logger.error("DEEPSEEK","Failed to parse tags response as JSON",e);const t=r.match(/"([^"]+)"/g);return t?t.map(e=>e.replace(/"/g,"")):[]}}async summarizeFAQ(e){const t=`\n      Summarize the following FAQ content in a concise paragraph:\n      \n      ${e}\n      \n      Keep the summary under 100 words.\n    `;return await this.generateText(t,{temperature:.3,max_tokens:200})}}exports.DeepSeekClient=DeepSeekClient;exports.deepseekClient=new DeepSeekClient;