"use strict";function isWalletError(r){return r instanceof WalletError}function toWalletError(r){return isWalletError(r)?r:r instanceof Error?new WalletError(r.message,"UNKNOWN_ERROR",500,{originalError:r.name,stack:r.stack}):new WalletError(String(r),"UNKNOWN_ERROR",500)}Object.defineProperty(exports,"__esModule",{value:!0});exports.UtxoError=exports.LedgerError=exports.TransferError=exports.NoActiveTokensError=exports.NetworkNotConfiguredError=exports.WalletDataNotFoundError=exports.EncryptionError=exports.ChainServiceUnavailableError=exports.AddressGenerationError=exports.MasterWalletExistsError=exports.MasterWalletNotFoundError=exports.WalletExistsError=exports.InvalidAmountError=exports.InvalidWalletTypeError=exports.WalletDisabledError=exports.NegativeInOrderError=exports.InsufficientHeldFundsError=exports.NegativeBalanceError=exports.PrecisionError=exports.ConcurrencyError=exports.DuplicateOperationError=exports.WalletNotFoundError=exports.InsufficientFundsError=exports.WalletError=void 0;exports.isWalletError=isWalletError;exports.toWalletError=toWalletError;class WalletError extends Error{constructor(r,e,t=400,o){super(r);this.name="WalletError";this.code=e;this.statusCode=t;this.details=o;Error.captureStackTrace&&Error.captureStackTrace(this,WalletError)}toJSON(){return{name:this.name,message:this.message,code:this.code,statusCode:this.statusCode,details:this.details}}}exports.WalletError=WalletError;class InsufficientFundsError extends WalletError{constructor(r,e,t){super(`Insufficient funds: ${r} ${t} available, ${e} required`,"INSUFFICIENT_FUNDS",400,{available:r,required:e,currency:t,deficit:e-r});this.name="InsufficientFundsError"}}exports.InsufficientFundsError=InsufficientFundsError;class WalletNotFoundError extends WalletError{constructor(r){super(`Wallet not found: ${r}`,"WALLET_NOT_FOUND",404,{identifier:r});this.name="WalletNotFoundError"}}exports.WalletNotFoundError=WalletNotFoundError;class DuplicateOperationError extends WalletError{constructor(r,e){super("Duplicate operation detected","DUPLICATE_OPERATION",409,{idempotencyKey:r,existingTransactionId:e});this.name="DuplicateOperationError"}}exports.DuplicateOperationError=DuplicateOperationError;class ConcurrencyError extends WalletError{constructor(r){super("Concurrent modification detected, please retry","CONCURRENCY_ERROR",409,{walletId:r});this.name="ConcurrencyError"}}exports.ConcurrencyError=ConcurrencyError;class PrecisionError extends WalletError{constructor(r,e){super(`Value ${r} exceeds allowed precision of ${e} decimal places`,"PRECISION_ERROR",400,{value:r,precision:e});this.name="PrecisionError"}}exports.PrecisionError=PrecisionError;class NegativeBalanceError extends WalletError{constructor(r,e){super("Operation would result in negative balance","NEGATIVE_BALANCE",400,{walletId:r,calculatedBalance:e});this.name="NegativeBalanceError"}}exports.NegativeBalanceError=NegativeBalanceError;class InsufficientHeldFundsError extends WalletError{constructor(r,e,t){super(`Insufficient held funds: ${r} ${t} held, ${e} required`,"INSUFFICIENT_HELD_FUNDS",400,{held:r,required:e,currency:t});this.name="InsufficientHeldFundsError"}}exports.InsufficientHeldFundsError=InsufficientHeldFundsError;class NegativeInOrderError extends WalletError{constructor(r,e){super("Operation would result in negative inOrder amount","NEGATIVE_IN_ORDER",400,{walletId:r,calculatedInOrder:e});this.name="NegativeInOrderError"}}exports.NegativeInOrderError=NegativeInOrderError;class WalletDisabledError extends WalletError{constructor(r){super("Wallet is disabled","WALLET_DISABLED",403,{walletId:r});this.name="WalletDisabledError"}}exports.WalletDisabledError=WalletDisabledError;class InvalidWalletTypeError extends WalletError{constructor(r){super(`Invalid wallet type: ${r}`,"INVALID_WALLET_TYPE",400,{type:r});this.name="InvalidWalletTypeError"}}exports.InvalidWalletTypeError=InvalidWalletTypeError;class InvalidAmountError extends WalletError{constructor(r,e){super(`Invalid amount: ${e}`,"INVALID_AMOUNT",400,{amount:r,reason:e});this.name="InvalidAmountError"}}exports.InvalidAmountError=InvalidAmountError;class WalletExistsError extends WalletError{constructor(r,e,t){super(`Wallet already exists: ${e}/${t} for user ${r}`,"WALLET_EXISTS",409,{userId:r,type:e,currency:t});this.name="WalletExistsError"}}exports.WalletExistsError=WalletExistsError;class MasterWalletNotFoundError extends WalletError{constructor(r){super(`Master wallet not found for chain: ${r}`,"MASTER_WALLET_NOT_FOUND",404,{chain:r});this.name="MasterWalletNotFoundError"}}exports.MasterWalletNotFoundError=MasterWalletNotFoundError;class MasterWalletExistsError extends WalletError{constructor(r){super(`Master wallet already exists for chain: ${r}`,"MASTER_WALLET_EXISTS",400,{chain:r});this.name="MasterWalletExistsError"}}exports.MasterWalletExistsError=MasterWalletExistsError;class AddressGenerationError extends WalletError{constructor(r,e){super(`Failed to generate address for ${r}: ${e}`,"ADDRESS_GENERATION_FAILED",500,{chain:r,reason:e});this.name="AddressGenerationError"}}exports.AddressGenerationError=AddressGenerationError;class ChainServiceUnavailableError extends WalletError{constructor(r){super(`Chain service not available: ${r}`,"SERVICE_UNAVAILABLE",503,{chain:r});this.name="ChainServiceUnavailableError"}}exports.ChainServiceUnavailableError=ChainServiceUnavailableError;class EncryptionError extends WalletError{constructor(r){super(`Failed to ${r} wallet data`,"ENCRYPTION_ERROR",500,{operation:r});this.name="EncryptionError"}}exports.EncryptionError=EncryptionError;class WalletDataNotFoundError extends WalletError{constructor(r,e){super(`Wallet data not found for ${r}/${e}`,"WALLET_DATA_NOT_FOUND",404,{walletId:r,chain:e});this.name="WalletDataNotFoundError"}}exports.WalletDataNotFoundError=WalletDataNotFoundError;class NetworkNotConfiguredError extends WalletError{constructor(r){super(`Network not configured for chain: ${r}`,"NETWORK_NOT_CONFIGURED",400,{chain:r});this.name="NetworkNotConfiguredError"}}exports.NetworkNotConfiguredError=NetworkNotConfiguredError;class NoActiveTokensError extends WalletError{constructor(r){super(`No active tokens found for currency: ${r}`,"NO_ACTIVE_TOKENS",400,{currency:r});this.name="NoActiveTokensError"}}exports.NoActiveTokensError=NoActiveTokensError;class TransferError extends WalletError{constructor(r,e){super(`Transfer failed: ${r}`,"TRANSFER_FAILED",400,e);this.name="TransferError"}}exports.TransferError=TransferError;class LedgerError extends WalletError{constructor(r,e){super(`Ledger operation failed: ${r}`,"LEDGER_ERROR",500,e);this.name="LedgerError"}}exports.LedgerError=LedgerError;class UtxoError extends WalletError{constructor(r,e){super(`UTXO operation failed: ${r}`,"UTXO_ERROR",500,e);this.name="UtxoError"}}exports.UtxoError=UtxoError;