"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.walletCreationService=exports.WalletCreationService=void 0;const db_1=require("@b/db"),console_1=require("@b/utils/console"),errors_1=require("./errors"),AddressGenerationService_1=require("./AddressGenerationService"),WalletDataService_1=require("./WalletDataService"),AuditLogger_1=require("./audit/AuditLogger");class WalletCreationService{constructor(){this.addressGenService=AddressGenerationService_1.AddressGenerationService.getInstance();this.walletDataService=WalletDataService_1.WalletDataService.getInstance()}static getInstance(){WalletCreationService.instance||(WalletCreationService.instance=new WalletCreationService);return WalletCreationService.instance}async createWallet(e){const{userId:t,type:a,currency:r,generateAddresses:s=!0}=e;return await db_1.sequelize.transaction(async e=>{const i=await db_1.models.wallet.findOne({where:{userId:t,type:a,currency:r},transaction:e});if(i)return"ECO"===a&&s?await this.ensureEcoWalletComplete(i,e):this.buildResult(this.toWalletAttributes(i));switch(a){case"FIAT":return await this.createFiatWallet(t,r,e);case"SPOT":return await this.createSpotWallet(t,r,e);case"ECO":return await this.createEcoWallet(t,r,s,e);case"FUTURES":return await this.createFuturesWallet(t,r,e);case"COPY_TRADING":return await this.createCopyTradingWallet(t,r,e);default:throw new errors_1.WalletError(`Unknown wallet type: ${a}`,"INVALID_WALLET_TYPE",400)}})}async createFiatWallet(e,t,a){const r=await db_1.models.wallet.create({userId:e,type:"FIAT",currency:t.toUpperCase(),balance:0,inOrder:0,status:!0},{transaction:a});await AuditLogger_1.auditLogger.logWalletCreated(r.id,e,"FIAT",t);return this.buildResult(this.toWalletAttributes(r))}async createSpotWallet(e,t,a){const r=await db_1.models.wallet.create({userId:e,type:"SPOT",currency:t.toUpperCase(),balance:0,inOrder:0,status:!0},{transaction:a});await AuditLogger_1.auditLogger.logWalletCreated(r.id,e,"SPOT",t);return this.buildResult(this.toWalletAttributes(r))}async createEcoWallet(e,t,a,r){const s=await db_1.models.wallet.create({userId:e,type:"ECO",currency:t.toUpperCase(),balance:0,inOrder:0,status:!0,address:JSON.stringify({})},{transaction:r});let i={};const n=[];if(a){const e=await this.getActiveTokens(t);0===e.length&&console_1.logger.warn("WALLET_CREATION",`No active tokens found for currency: ${t}, creating wallet without addresses`);for(const a of e)try{const e=await this.addressGenService.generateAddress({walletId:s.id,currency:t,chain:a.chain,contractType:a.contractType,network:a.network,transaction:r});i[a.chain]={address:e.address,network:e.network,balance:0};const l=await this.walletDataService.create({walletId:s.id,currency:t,chain:a.chain,address:e.address,index:e.index,encryptedData:e.encryptedData,transaction:r});n.push(l)}catch(e){console_1.logger.error("WALLET_CREATION",`Failed to generate address for ${a.chain}: ${e.message}`)}Object.keys(i).length>0&&await db_1.models.wallet.update({address:JSON.stringify(i)},{where:{id:s.id},transaction:r})}await AuditLogger_1.auditLogger.logWalletCreated(s.id,e,"ECO",t,Object.keys(i));const l=await db_1.models.wallet.findByPk(s.id,{transaction:r});return this.buildResult(this.toWalletAttributes(l),n,i)}async createFuturesWallet(e,t,a){const r=await db_1.models.wallet.create({userId:e,type:"FUTURES",currency:t.toUpperCase(),balance:0,inOrder:0,status:!0},{transaction:a});await AuditLogger_1.auditLogger.logWalletCreated(r.id,e,"FUTURES",t);return this.buildResult(this.toWalletAttributes(r))}async createCopyTradingWallet(e,t,a){const r=await db_1.models.wallet.create({userId:e,type:"COPY_TRADING",currency:t.toUpperCase(),balance:0,inOrder:0,status:!0},{transaction:a});await AuditLogger_1.auditLogger.logWalletCreated(r.id,e,"COPY_TRADING",t);return this.buildResult(this.toWalletAttributes(r))}async ensureEcoWalletComplete(e,t){const a=await this.getActiveTokens(e.currency);let r=this.parseAddresses(e.address);const s=[];let i=!1;for(const n of a)if(!r[n.chain])try{const a=await this.addressGenService.generateAddress({walletId:e.id,currency:e.currency,chain:n.chain,contractType:n.contractType,network:n.network,transaction:t});r[n.chain]={address:a.address,network:a.network,balance:0};const l=await this.walletDataService.create({walletId:e.id,currency:e.currency,chain:n.chain,address:a.address,index:a.index,encryptedData:a.encryptedData,transaction:t});s.push(l);i=!0;console_1.logger.info("WALLET_CREATION",`Added missing address for ${n.chain} to wallet ${e.id}`)}catch(e){console_1.logger.error("WALLET_CREATION",`Failed to add missing address for ${n.chain}: ${e.message}`)}i&&await db_1.models.wallet.update({address:JSON.stringify(r)},{where:{id:e.id},transaction:t});const n=await db_1.models.wallet.findByPk(e.id,{transaction:t});return this.buildResult(this.toWalletAttributes(n),s,r)}async getActiveTokens(e){if(!db_1.models.ecosystemToken){console_1.logger.warn("WALLET_CREATION","EcosystemToken model not available");return[]}return(await db_1.models.ecosystemToken.findAll({where:{currency:e,status:!0}})).filter(e=>{if(["XMR","TON","SOL","TRON","BTC","LTC","DOGE","DASH"].includes(e.chain))return!0;const t=`${e.chain.toUpperCase()}_NETWORK`,a=process.env[t];return!!a&&(e.network===a||e.network===e.chain&&"mainnet"===a)})}parseAddresses(e){if(!e)return{};if("string"==typeof e)try{return JSON.parse(e)}catch(e){return{}}return e}async getOrCreateWallet(e,t,a,r){const s=await db_1.models.wallet.findOne({where:{userId:e,type:t,currency:a},...r&&{transaction:r}});return s?"ECO"===t?r?await this.ensureEcoWalletComplete(s,r):await db_1.sequelize.transaction(async e=>await this.ensureEcoWalletComplete(s,e)):this.buildResult(this.toWalletAttributes(s)):r?await this.createWalletWithTransaction({userId:e,type:t,currency:a},r):await this.createWallet({userId:e,type:t,currency:a})}async createWalletWithTransaction(e,t){const{userId:a,type:r,currency:s,generateAddresses:i=!0}=e,n=await db_1.models.wallet.findOne({where:{userId:a,type:r,currency:s},transaction:t});if(n)return"ECO"===r&&i?await this.ensureEcoWalletComplete(n,t):this.buildResult(this.toWalletAttributes(n));switch(r){case"FIAT":return await this.createFiatWallet(a,s,t);case"SPOT":return await this.createSpotWallet(a,s,t);case"ECO":return await this.createEcoWallet(a,s,i,t);case"FUTURES":return await this.createFuturesWallet(a,s,t);case"COPY_TRADING":return await this.createCopyTradingWallet(a,s,t);default:throw new errors_1.WalletError(`Unknown wallet type: ${r}`,"INVALID_WALLET_TYPE",400)}}async getWalletById(e){const t=await db_1.models.wallet.findByPk(e);return t?this.toWalletAttributes(t):null}async getWallet(e,t,a){const r=await db_1.models.wallet.findOne({where:{userId:e,type:t,currency:a}});return r?this.toWalletAttributes(r):null}async getUserWallets(e,t){const a={userId:e};t&&(a.type=t);return(await db_1.models.wallet.findAll({where:a})).map(e=>this.toWalletAttributes(e))}toWalletAttributes(e){var t,a;const r=e.get?e.get({plain:!0}):e;return{...r,balance:parseFloat((null===(t=r.balance)||void 0===t?void 0:t.toString())||"0"),inOrder:parseFloat((null===(a=r.inOrder)||void 0===a?void 0:a.toString())||"0")}}buildResult(e,t,a){return{wallet:e,walletData:t,addresses:a,id:e.id,balance:e.balance}}}exports.WalletCreationService=WalletCreationService;exports.walletCreationService=WalletCreationService.getInstance();