"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.PrecisionCacheService=exports.precisionCacheService=void 0;const db_1=require("@b/db"),console_1=require("@b/utils/console");class PrecisionCacheService{constructor(){this.fiatPrecisions={};this.spotPrecisions={};this.ecoPrecisions={};this.initialized=!1;this.initializing=null;this.DEFAULT_FIAT_PRECISION=2;this.DEFAULT_SPOT_PRECISION=8;this.DEFAULT_ECO_PRECISION=8;this.DEFAULT_ECO_DECIMALS=18}static getInstance(){PrecisionCacheService.instance||(PrecisionCacheService.instance=new PrecisionCacheService);return PrecisionCacheService.instance}async initialize(){if(!this.initialized){if(this.initializing)return this.initializing;this.initializing=this._doInitialize();await this.initializing;this.initializing=null}}async _doInitialize(){try{await Promise.all([this.loadFiatPrecisions(),this.loadSpotPrecisions(),this.loadEcoPrecisions()]);this.initialized=!0;console_1.logger.success("PRECISION_CACHE","Precision cache initialized successfully")}catch(i){console_1.logger.error("PRECISION_CACHE","Failed to initialize precision cache",i)}}async loadFiatPrecisions(){try{const i=await db_1.models.currency.findAll({attributes:["symbol","precision"],where:{status:!0}}),e=new Date;this.fiatPrecisions={};for(const s of i)this.fiatPrecisions[s.symbol.toUpperCase()]={precision:s.precision,lastUpdated:e};console_1.logger.debug("PRECISION_CACHE",`Loaded ${i.length} FIAT precisions`)}catch(i){console_1.logger.error("PRECISION_CACHE","Failed to load FIAT precisions",i)}}async loadSpotPrecisions(){try{const i=await db_1.models.exchangeCurrency.findAll({attributes:["currency","precision"],where:{status:!0}}),e=new Date;this.spotPrecisions={};for(const s of i)this.spotPrecisions[s.currency.toUpperCase()]={precision:s.precision,lastUpdated:e};console_1.logger.debug("PRECISION_CACHE",`Loaded ${i.length} SPOT precisions`)}catch(i){console_1.logger.error("PRECISION_CACHE","Failed to load SPOT precisions",i)}}async loadEcoPrecisions(){var i,e;try{const s=await db_1.models.ecosystemToken.findAll({attributes:["currency","chain","precision","decimals"],where:{status:!0}}),t=new Date;this.ecoPrecisions={};for(const o of s){const s=o.currency.toUpperCase(),n=o.chain.toUpperCase();this.ecoPrecisions[s]||(this.ecoPrecisions[s]={});this.ecoPrecisions[s][n]={precision:null!==(i=o.precision)&&void 0!==i?i:this.DEFAULT_ECO_PRECISION,decimals:null!==(e=o.decimals)&&void 0!==e?e:this.DEFAULT_ECO_DECIMALS,lastUpdated:t}}console_1.logger.debug("PRECISION_CACHE",`Loaded ${s.length} ECO token precisions`)}catch(i){console_1.logger.error("PRECISION_CACHE","Failed to load ECO precisions",i)}}async getPrecision(i,e,s){var t,o,n,c,a,r,l,d,h;this.initialized||await this.initialize();const C=e.toUpperCase();switch(i){case"FIAT":return null!==(o=null===(t=this.fiatPrecisions[C])||void 0===t?void 0:t.precision)&&void 0!==o?o:this.DEFAULT_FIAT_PRECISION;case"SPOT":return null!==(c=null===(n=this.spotPrecisions[C])||void 0===n?void 0:n.precision)&&void 0!==c?c:this.DEFAULT_SPOT_PRECISION;case"ECO":case"FUTURES":case"COPY_TRADING":if(s){const i=s.toUpperCase();return null!==(l=null===(r=null===(a=this.ecoPrecisions[C])||void 0===a?void 0:a[i])||void 0===r?void 0:r.precision)&&void 0!==l?l:this.DEFAULT_ECO_PRECISION}const i=this.ecoPrecisions[C];if(i){return null!==(h=null===(d=i[Object.keys(i)[0]])||void 0===d?void 0:d.precision)&&void 0!==h?h:this.DEFAULT_ECO_PRECISION}return this.DEFAULT_ECO_PRECISION;default:return this.DEFAULT_SPOT_PRECISION}}async getDecimals(i,e){var s,t,o;this.initialized||await this.initialize();const n=i.toUpperCase(),c=e.toUpperCase();return null!==(o=null===(t=null===(s=this.ecoPrecisions[n])||void 0===s?void 0:s[c])||void 0===t?void 0:t.decimals)&&void 0!==o?o:this.DEFAULT_ECO_DECIMALS}async getChainsForCurrency(i){this.initialized||await this.initialize();const e=this.ecoPrecisions[i.toUpperCase()];return e?Object.keys(e):[]}async invalidateFiatCache(){await this.loadFiatPrecisions();console_1.logger.info("PRECISION_CACHE","FIAT precision cache invalidated and reloaded")}async invalidateFiatCurrency(i){try{const e=await db_1.models.currency.findOne({attributes:["symbol","precision"],where:{symbol:i,status:!0}});e?this.fiatPrecisions[i.toUpperCase()]={precision:e.precision,lastUpdated:new Date}:delete this.fiatPrecisions[i.toUpperCase()];console_1.logger.info("PRECISION_CACHE",`FIAT currency ${i} cache invalidated`)}catch(e){console_1.logger.error("PRECISION_CACHE",`Failed to invalidate FIAT currency ${i}`,e)}}async invalidateSpotCache(){await this.loadSpotPrecisions();console_1.logger.info("PRECISION_CACHE","SPOT precision cache invalidated and reloaded")}async invalidateSpotCurrency(i){try{const e=await db_1.models.exchangeCurrency.findOne({attributes:["currency","precision"],where:{currency:i,status:!0}});e?this.spotPrecisions[i.toUpperCase()]={precision:e.precision,lastUpdated:new Date}:delete this.spotPrecisions[i.toUpperCase()];console_1.logger.info("PRECISION_CACHE",`SPOT currency ${i} cache invalidated`)}catch(e){console_1.logger.error("PRECISION_CACHE",`Failed to invalidate SPOT currency ${i}`,e)}}async invalidateEcoCache(){await this.loadEcoPrecisions();console_1.logger.info("PRECISION_CACHE","ECO precision cache invalidated and reloaded")}async invalidateEcoToken(i,e){var s,t;try{const o=await db_1.models.ecosystemToken.findOne({attributes:["currency","chain","precision","decimals"],where:{currency:i,chain:e,status:!0}}),n=i.toUpperCase(),c=e.toUpperCase();if(o){this.ecoPrecisions[n]||(this.ecoPrecisions[n]={});this.ecoPrecisions[n][c]={precision:null!==(s=o.precision)&&void 0!==s?s:this.DEFAULT_ECO_PRECISION,decimals:null!==(t=o.decimals)&&void 0!==t?t:this.DEFAULT_ECO_DECIMALS,lastUpdated:new Date}}else if(this.ecoPrecisions[n]){delete this.ecoPrecisions[n][c];0===Object.keys(this.ecoPrecisions[n]).length&&delete this.ecoPrecisions[n]}console_1.logger.info("PRECISION_CACHE",`ECO token ${i}/${e} cache invalidated`)}catch(s){console_1.logger.error("PRECISION_CACHE",`Failed to invalidate ECO token ${i}/${e}`,s)}}async invalidateAll(){await Promise.all([this.loadFiatPrecisions(),this.loadSpotPrecisions(),this.loadEcoPrecisions()]);console_1.logger.info("PRECISION_CACHE","All precision caches invalidated and reloaded")}async reinitialize(){this.initialized=!1;this.fiatPrecisions={};this.spotPrecisions={};this.ecoPrecisions={};await this.initialize()}async formatAmount(i,e,s,t){const o=await this.getPrecision(e,s,t);return parseFloat(i.toFixed(o))}isInitialized(){return this.initialized}getStats(){return{fiatCount:Object.keys(this.fiatPrecisions).length,spotCount:Object.keys(this.spotPrecisions).length,ecoCount:Object.values(this.ecoPrecisions).reduce((i,e)=>i+Object.keys(e).length,0),initialized:this.initialized}}}exports.PrecisionCacheService=PrecisionCacheService;exports.precisionCacheService=PrecisionCacheService.getInstance();