"use strict";var __createBinding=this&&this.__createBinding||(Object.create?function(e,t,r,a){void 0===a&&(a=r);var s=Object.getOwnPropertyDescriptor(t,r);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[r]}});Object.defineProperty(e,a,s)}:function(e,t,r,a){void 0===a&&(a=r);e[a]=t[r]}),__setModuleDefault=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),__importStar=this&&this.__importStar||function(){var e=function(t){e=Object.getOwnPropertyNames||function(e){var t=[];for(var r in e)Object.prototype.hasOwnProperty.call(e,r)&&(t[t.length]=r);return t};return e(t)};return function(t){if(t&&t.__esModule)return t;var r={};if(null!=t)for(var a=e(t),s=0;s<a.length;s++)"default"!==a[s]&&__createBinding(r,t,a[s]);__setModuleDefault(r,t);return r}}();Object.defineProperty(exports,"__esModule",{value:!0});exports.masterWalletService=exports.MasterWalletService=void 0;const db_1=require("@b/db"),ethers_1=require("ethers"),encrypt_1=require("@b/utils/encrypt"),console_1=require("@b/utils/console"),fs=__importStar(require("fs")),path=__importStar(require("path")),errors_1=require("./errors"),constants_1=require("./constants");class MasterWalletService{constructor(){this.walletDir=path.join(process.cwd(),"ecosystem","wallets");this.ensureWalletDirectory()}static getInstance(){MasterWalletService.instance||(MasterWalletService.instance=new MasterWalletService);return MasterWalletService.instance}ensureWalletDirectory(){try{if(!fs.existsSync(this.walletDir)){fs.mkdirSync(this.walletDir,{recursive:!0});console_1.logger.debug("MASTER_WALLET",`Created wallet directory: ${this.walletDir}`)}}catch(e){console_1.logger.warn("MASTER_WALLET",`Failed to create wallet directory: ${e.message}`)}}async getMasterWallet(e){if(!db_1.models.ecosystemMasterWallet){console_1.logger.warn("MASTER_WALLET","EcosystemMasterWallet model not available");return null}const t=await db_1.models.ecosystemMasterWallet.findOne({where:{chain:e,status:!0}});return t?this.toAttributes(t):null}async getMasterWalletById(e){if(!db_1.models.ecosystemMasterWallet)return null;const t=await db_1.models.ecosystemMasterWallet.findByPk(e);return t?this.toAttributes(t):null}async getAllMasterWallets(){if(!db_1.models.ecosystemMasterWallet)return[];return(await db_1.models.ecosystemMasterWallet.findAll()).map(e=>this.toAttributes(e))}async getMasterWalletOrThrow(e){const t=await this.getMasterWallet(e);if(!t)throw new errors_1.MasterWalletNotFoundError(e);return t}async createMasterWallet(e){const{chain:t,currency:r}=e;if(!db_1.models.ecosystemMasterWallet)throw new errors_1.WalletError("EcosystemMasterWallet model not available","MODEL_NOT_AVAILABLE",500);if(await db_1.models.ecosystemMasterWallet.findOne({where:{chain:t}}))throw new errors_1.MasterWalletExistsError(t);let a;if((0,constants_1.isUtxoChain)(t))a=await this.createUtxoMasterWallet(t);else switch(t){case"SOL":a=await this.createSolanaMasterWallet();break;case"TRON":a=await this.createTronMasterWallet();break;case"XMR":a=await this.createMoneroMasterWallet();break;case"TON":a=await this.createTonMasterWallet();break;default:a=await this.createEvmMasterWallet()}try{const e=path.join(this.walletDir,`${t}.json`);fs.writeFileSync(e,JSON.stringify(a),"utf8");console_1.logger.info("MASTER_WALLET",`Saved master wallet backup to ${e}`)}catch(e){console_1.logger.warn("MASTER_WALLET",`Failed to save wallet backup: ${e.message}`)}const s=(0,encrypt_1.encrypt)(JSON.stringify(a.data)),l=await db_1.models.ecosystemMasterWallet.create({chain:t,currency:r||t,address:a.address,balance:0,data:s,status:!0,lastIndex:0});console_1.logger.success("MASTER_WALLET",`Created master wallet for ${t}: ${a.address}`);return this.toAttributes(l)}async createEvmMasterWallet(){const e=ethers_1.ethers.Wallet.createRandom();if(!e.mnemonic)throw new errors_1.WalletError("Failed to generate mnemonic","MNEMONIC_FAILED",500);const t=ethers_1.ethers.HDNodeWallet.fromPhrase(e.mnemonic.phrase);return{address:t.address,data:{mnemonic:t.mnemonic.phrase,publicKey:t.publicKey,privateKey:t.privateKey,xprv:t.extendedKey,xpub:t.neuter().extendedKey,chainCode:t.chainCode,path:t.path}}}async createUtxoMasterWallet(e){try{const t=await Promise.resolve().then(()=>__importStar(require("bitcoinjs-lib"))),{ECPairFactory:r}=await Promise.resolve().then(()=>__importStar(require("ecpair"))),a=r(await Promise.resolve().then(()=>__importStar(require("tiny-secp256k1")))),s=this.getUtxoNetwork(e,t),l=a.makeRandom({network:s}),{address:o}=t.payments.p2pkh({pubkey:Buffer.from(l.publicKey),network:s});if(!o)throw new errors_1.WalletError(`Failed to generate ${e} address`,"ADDRESS_FAILED",500);return{address:o,data:{privateKey:l.toWIF(),publicKey:Buffer.from(l.publicKey).toString("hex")}}}catch(e){throw new errors_1.WalletError(`Failed to create UTXO master wallet: ${e.message}`,"UTXO_CREATION_FAILED",500)}}getUtxoNetwork(e,t){return{BTC:t.networks.bitcoin,LTC:{messagePrefix:"Litecoin Signed Message:\n",bech32:"ltc",bip32:{public:27108450,private:27106558},pubKeyHash:48,scriptHash:50,wif:176},DOGE:{messagePrefix:"Dogecoin Signed Message:\n",bip32:{public:49990397,private:49988504},pubKeyHash:30,scriptHash:22,wif:158},DASH:{messagePrefix:"DarkCoin Signed Message:\n",bip32:{public:50221772,private:50221816},pubKeyHash:76,scriptHash:16,wif:204}}[e]||t.networks.bitcoin}async createSolanaMasterWallet(){try{const{getSolanaService:e}=await Promise.resolve().then(()=>__importStar(require("@b/utils/safe-imports"))),t=await e();if(!t)throw new errors_1.WalletError("Solana service not available","SERVICE_UNAVAILABLE",503);return(await t.getInstance()).createWallet()}catch(e){if(e instanceof errors_1.WalletError)throw e;throw new errors_1.WalletError(`Failed to create Solana master wallet: ${e.message}`,"SOLANA_CREATION_FAILED",500)}}async createTronMasterWallet(){try{const{getTronService:e}=await Promise.resolve().then(()=>__importStar(require("@b/utils/safe-imports"))),t=await e();if(!t)throw new errors_1.WalletError("Tron service not available","SERVICE_UNAVAILABLE",503);return(await t.getInstance()).createWallet()}catch(e){if(e instanceof errors_1.WalletError)throw e;throw new errors_1.WalletError(`Failed to create Tron master wallet: ${e.message}`,"TRON_CREATION_FAILED",500)}}async createMoneroMasterWallet(){try{const{getMoneroService:e}=await Promise.resolve().then(()=>__importStar(require("@b/utils/safe-imports"))),t=await e();if(!t)throw new errors_1.WalletError("Monero service not available","SERVICE_UNAVAILABLE",503);return(await t.getInstance()).createWallet("master_wallet")}catch(e){if(e instanceof errors_1.WalletError)throw e;throw new errors_1.WalletError(`Failed to create Monero master wallet: ${e.message}`,"MONERO_CREATION_FAILED",500)}}async createTonMasterWallet(){try{const{getTonService:e}=await Promise.resolve().then(()=>__importStar(require("@b/utils/safe-imports"))),t=await e();if(!t)throw new errors_1.WalletError("TON service not available","SERVICE_UNAVAILABLE",503);return(await t.getInstance()).createWallet()}catch(e){if(e instanceof errors_1.WalletError)throw e;throw new errors_1.WalletError(`Failed to create TON master wallet: ${e.message}`,"TON_CREATION_FAILED",500)}}async updateBalance(e,t,r){if(db_1.models.ecosystemMasterWallet){await db_1.models.ecosystemMasterWallet.update({balance:t},{where:{chain:e},...r&&{transaction:r}});console_1.logger.debug("MASTER_WALLET",`Updated balance for ${e}: ${t}`)}}async incrementBalance(e,t,r){const a=await this.getMasterWallet(e);if(!a)throw new errors_1.MasterWalletNotFoundError(e);const s=a.balance+t;await this.updateBalance(e,s,r)}async decrementBalance(e,t,r){const a=await this.getMasterWallet(e);if(!a)throw new errors_1.MasterWalletNotFoundError(e);const s=a.balance-t;if(s<0)throw new errors_1.WalletError(`Insufficient master wallet balance: ${a.balance} < ${t}`,"INSUFFICIENT_MASTER_BALANCE",400);await this.updateBalance(e,s,r)}async getNextIndex(e,t){if(!db_1.models.ecosystemMasterWallet)throw new errors_1.WalletError("EcosystemMasterWallet model not available","MODEL_NOT_AVAILABLE",500);const r=await db_1.models.ecosystemMasterWallet.findOne({where:{chain:e,status:!0},...t&&{transaction:t}});if(!r)throw new errors_1.MasterWalletNotFoundError(e);const a=(r.lastIndex||0)+1;await db_1.models.ecosystemMasterWallet.update({lastIndex:a},{where:{id:r.id},...t&&{transaction:t}});return a}async getDecryptedData(e){const t=await this.getMasterWallet(e);if(!t||!t.data)throw new errors_1.MasterWalletNotFoundError(e);try{return JSON.parse((0,encrypt_1.decrypt)(t.data))}catch(e){throw new errors_1.WalletError(`Failed to decrypt master wallet data: ${e.message}`,"DECRYPTION_FAILED",500)}}async setStatus(e,t){if(db_1.models.ecosystemMasterWallet){await db_1.models.ecosystemMasterWallet.update({status:t},{where:{chain:e}});console_1.logger.info("MASTER_WALLET",`Set status for ${e} to ${t}`)}}async activate(e){await this.setStatus(e,!0)}async deactivate(e){await this.setStatus(e,!1)}toAttributes(e){var t,r;const a=e.get?e.get({plain:!0}):e;return{...a,balance:parseFloat((null===(t=a.balance)||void 0===t?void 0:t.toString())||"0"),lastIndex:parseInt((null===(r=a.lastIndex)||void 0===r?void 0:r.toString())||"0",10)}}async exists(e){return null!==await this.getMasterWallet(e)}async getAddress(e){const t=await this.getMasterWallet(e);return(null==t?void 0:t.address)||null}}exports.MasterWalletService=MasterWalletService;exports.masterWalletService=MasterWalletService.getInstance();