"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),token_1=require("@b/utils/token");exports.metadata={summary:"Update user notification preferences",description:"Updates the notification preferences for a user using their unsubscribe token.",operationId:"updateUnsubscribePreferences",tags:["User","Unsubscribe"],requiresAuth:!1,query:[{name:"token",in:"query",required:!0,schema:{type:"string"},description:"The unsubscribe token from the email"}],requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{email:{type:"boolean",description:"Email notification preference"},sms:{type:"boolean",description:"SMS notification preference"},push:{type:"boolean",description:"Push notification preference"}}}}}},responses:{200:{description:"Preferences updated successfully.",content:{"application/json":{schema:{type:"object",properties:{message:{type:"string"},email:{type:"boolean"},sms:{type:"boolean"},push:{type:"boolean"}}}}}},400:{description:"Invalid or expired token"},404:{description:"User not found"},500:{description:"Internal Server Error"}}};exports.default=async e=>{const{ctx:r,query:s,body:t}=e,{token:n}=s,{email:o,sms:i,push:a}=t;if(!n){null==r||r.fail("Token is required");throw(0,error_1.createError)({statusCode:400,message:"Token is required"})}null==r||r.step("Verifying unsubscribe token");const u=await(0,token_1.verifyUnsubscribeToken)(n);if(!u){null==r||r.fail("Invalid or expired token");throw(0,error_1.createError)({statusCode:400,message:"Invalid or expired token"})}null==r||r.step("Fetching user");const c=await db_1.models.user.findByPk(u);if(!c){null==r||r.fail("User not found");throw(0,error_1.createError)({statusCode:404,message:"User not found"})}null==r||r.step("Updating preferences");const p=c.settings||{email:!0,sms:!0,push:!0},d={email:void 0!==o?o:p.email,sms:void 0!==i?i:p.sms,push:void 0!==a?a:p.push};await c.update({settings:d});null==r||r.success("Preferences updated successfully");return{message:"Preferences updated successfully",...d}};