"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),console_1=require("@b/utils/console"),query_1=require("@b/utils/query"),constants_1=require("@b/utils/constants"),utils_1=require("./utils"),error_1=require("@b/utils/error");exports.metadata={summary:"Lists all tickets for the logged-in user",operationId:"listTickets",tags:["Support"],description:"Fetches all support tickets associated with the currently authenticated user.",logModule:"USER",logTitle:"List support tickets",parameters:constants_1.crudParameters,responses:{200:{description:"Posts retrieved successfully",content:{"application/json":{schema:{type:"object",properties:{data:{type:"array",items:{type:"object",properties:utils_1.baseSupportTicketSchema}},pagination:constants_1.paginationSchema}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Support Ticket"),500:query_1.serverErrorResponse},requiresAuth:!0};exports.default=async e=>{var t;const{user:s,query:r,ctx:a}=e;if(!(null==s?void 0:s.id)){null==a||a.fail("User not authenticated");throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"})}null==a||a.step("Retrieving support tickets");const i=await(0,query_1.getFiltered)({model:db_1.models.supportTicket,query:r,sortField:r.sortField||"createdAt",where:{userId:s.id},includeModels:[{model:db_1.models.user,as:"user",attributes:["id","firstName","lastName","email","avatar"]},{model:db_1.models.user,as:"agent",attributes:["id","firstName","lastName","email","avatar"]}]});i.items&&Array.isArray(i.items)&&(i.items=i.items.map(e=>{if("string"==typeof e.messages)try{e.messages=JSON.parse(e.messages)}catch(t){console_1.logger.warn("SUPPORT","Failed to parse messages JSON");e.messages=[]}if("string"==typeof e.tags)try{e.tags=JSON.parse(e.tags)}catch(t){console_1.logger.warn("SUPPORT","Failed to parse tags JSON");e.tags=[]}e.messages=e.messages||[];e.tags=e.tags||[];return e}));null==a||a.success(`Retrieved ${(null===(t=i.items)||void 0===t?void 0:t.length)||0} support tickets`);return i};