"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const error_1=require("@b/utils/error"),otplib_1=require("otplib"),query_1=require("@b/utils/query"),index_post_1=require("./index.post");exports.metadata={summary:"Verifies an OTP with the provided secret and type, and saves it if valid",operationId:"verifyOTP",description:"Verifies an OTP with the provided secret and type, and saves it if valid",tags:["Profile"],requiresAuth:!0,logModule:"USER",logTitle:"Verify OTP",requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{otp:{type:"string",description:"OTP to verify"},secret:{type:"string",description:"OTP secret"},type:{type:"string",description:"Type of OTP",enum:["EMAIL","SMS","APP"]}},required:["otp","secret","type"]}}}},responses:{200:{description:"OTP verified and saved successfully",content:{"application/json":{schema:{type:"object",properties:{status:{type:"boolean",description:"Indicates if the request was successful"},statusCode:{type:"number",description:"HTTP status code",example:200},data:{type:"object",properties:{message:{type:"string",description:"Message indicating the status of the OTP verification"}}}}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("User"),500:query_1.serverErrorResponse}};exports.default=async e=>{const{user:t,body:s,ctx:r}=e;if(!(null==t?void 0:t.id)){null==r||r.fail("User not authenticated");throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"})}const{otp:i,secret:o,type:a}=s;null==r||r.step("Verifying OTP");if(!otplib_1.authenticator.verify({token:i,secret:o})){null==r||r.fail("Invalid OTP provided");throw(0,error_1.createError)({statusCode:401,message:"Invalid OTP"})}null==r||r.step("Saving OTP configuration");await(0,index_post_1.saveOTPQuery)(t.id,o,a);null==r||r.success("OTP verified and saved successfully");return{message:"OTP verified and saved successfully"}};