"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const error_1=require("@b/utils/error"),db_1=require("@b/db");exports.metadata={summary:"Verify phone number with code",operationId:"verifyPhoneNumber",tags:["User","Phone"],requiresAuth:!0,logModule:"USER",logTitle:"Verify phone number",requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{code:{type:"string",description:"Verification code sent to phone"}},required:["code"]}}}},responses:{200:{description:"Phone verified"},400:{description:"Invalid or expired code"},401:{description:"Unauthorized"}}};exports.default=async e=>{const{user:r,body:i,ctx:o}=e;if(!r){null==o||o.fail("User not authenticated");throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"})}const{code:t}=i;null==o||o.step("Retrieving user record");const n=await db_1.models.user.findByPk(r.id);null==o||o.step("Validating verification code");if(!n.phoneVerificationCode||!n.phoneVerificationExpiresAt||n.phoneVerificationCode!==t||new Date(n.phoneVerificationExpiresAt)<new Date){null==o||o.fail("Invalid or expired verification code");throw(0,error_1.createError)({statusCode:400,message:"Invalid or expired code"})}null==o||o.step("Updating phone verification status");await n.update({phone:n.phoneTemp,phoneVerified:!0,phoneVerificationCode:null,phoneVerificationExpiresAt:null,phoneTemp:null});null==o||o.success("Phone number verified successfully");return{message:"Phone number verified successfully."}};