"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error");exports.metadata={summary:"Get Notifications for Creator",description:"Retrieves notifications for the authenticated creator along with aggregated statistics.",operationId:"getCreatorNotifications",tags:["ICO","Creator","Notifications"],requiresAuth:!0,responses:{200:{description:"Notifications retrieved successfully.",content:{"application/json":{schema:{type:"object",properties:{notifications:{type:"array",items:{type:"object"}},stats:{type:"object",properties:{total:{type:"number"},unread:{type:"number"},types:{type:"object",properties:{investment:{type:"number"},message:{type:"number"},alert:{type:"number"},system:{type:"number"},user:{type:"number"}}},trend:{type:"object",properties:{percentage:{type:"number"},increasing:{type:"boolean"}}}}}}}}}},401:{description:"Unauthorized"},500:{description:"Internal Server Error"}}};exports.default=async e=>{const{user:t,ctx:r}=e;if(!(null==t?void 0:t.id)){null==r||r.fail("User not authenticated");throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"})}null==r||r.step("Fetching notifications");const s=await db_1.models.notification.findAll({where:{userId:t.id},order:[["createdAt","DESC"]],raw:!0});null==r||r.step("Calculating statistics");const i=s.length,n=s.filter(e=>!e.read).length,o=s.reduce((e,t)=>{e[t.type]=(e[t.type]||0)+1;return e},{}),a={total:i,unread:n,types:{investment:o.investment||0,message:o.message||0,alert:o.alert||0,system:o.system||0,user:o.user||0},trend:{percentage:0,increasing:!0}};null==r||r.success(`Retrieved ${i} notifications (${n} unread)`);return{notifications:s,stats:a}};