"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const error_1=require("@b/utils/error"),db_1=require("@b/db"),utils_1=require("./utils");exports.metadata={summary:"Creates a new API key",description:"Generates a new API key for the authenticated user.",operationId:"createApiKey",tags:["API Key Management"],logModule:"USER",logTitle:"Create API key",requestBody:{description:"Data required to create a new API key",content:{"application/json":{schema:{type:"object",properties:{name:{type:"string",description:"Name of the API key"},permissions:{type:"array",items:{type:"string"},description:"Permissions associated with the API key"},ipWhitelist:{type:"array",items:{type:"string"},description:"IP addresses whitelisted for the API key"},ipRestriction:{type:"boolean",description:"Restrict access to specific IPs (true) or allow unrestricted access (false)"}},required:["name"]}}}},responses:{200:{description:"API key created successfully",content:{"application/json":{schema:{type:"object",properties:{id:{type:"string"},name:{type:"string"},key:{type:"string"},permissions:{type:"array",items:{type:"string"}},ipWhitelist:{type:"array",items:{type:"string"}},ipRestriction:{type:"boolean"}}}}}},401:{description:"Unauthorized"},400:{description:"API key limit reached"},500:{description:"Server error"}},requiresAuth:!0};exports.default=async e=>{const{user:t,body:i,ctx:r}=e;if(!t){null==r||r.fail("User not authenticated");throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"})}const{name:s,permissions:a,ipWhitelist:o,ipRestriction:n}=i;null==r||r.step("Checking API key limit");if(await db_1.models.apiKey.count({where:{userId:t.id}})>=10){null==r||r.fail("API key limit reached (10 keys)");throw(0,error_1.createError)({statusCode:400,message:"You have reached the limit of 10 API keys."})}null==r||r.step("Generating new API key");const p=await db_1.models.apiKey.create({userId:t.id,name:s,key:(0,utils_1.generateApiKey)(),permissions:a||[],ipWhitelist:o||[],ipRestriction:null!=n&&n,type:"user"});null==r||r.success("API key created successfully");return p};