"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),passwords_1=require("@b/utils/passwords");exports.metadata={summary:"Delete own user account",description:"Allow users to delete their own account (soft delete)",operationId:"deleteOwnAccount",tags:["User","Account"],logModule:"USER",logTitle:"Delete account",requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{confirmPassword:{type:"string",description:"User's current password for confirmation"}},required:["confirmPassword"]}}}},responses:{200:{description:"Account deleted successfully",content:{"application/json":{schema:{type:"object",properties:{message:{type:"string"}}}}}},400:{description:"Bad request"},401:{description:"Unauthorized"},403:{description:"Forbidden"}},requiresAuth:!0};exports.default=async e=>{const{body:r,user:s,ctx:t}=e,{confirmPassword:o}=r;if(!(null==s?void 0:s.id)){null==t||t.fail("User not authenticated");throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"})}null==t||t.step("Retrieving user account");const n=await db_1.models.user.findOne({where:{id:s.id},include:[{model:db_1.models.role,as:"role",attributes:["name"]}]});if(!n){null==t||t.fail("User not found");throw(0,error_1.createError)({statusCode:404,message:"User not found"})}null==t||t.step("Validating user permissions");if(n.role&&"Super Admin"===n.role.name){null==t||t.fail("Super Admin accounts cannot be self-deleted");throw(0,error_1.createError)({statusCode:403,message:"Super Admin accounts cannot be self-deleted"})}if(o&&n.password){if(!await(0,passwords_1.verifyPassword)(n.password,o))throw(0,error_1.createError)({statusCode:400,message:"Incorrect password"})}null==t||t.step("Deleting user account");await n.destroy();null==t||t.success("Account deleted successfully");return{message:"Your account has been successfully deleted"}};