"use strict";function countDecimals(e){var a;if(Number.isInteger(e))return 0;const t=e.toString();if(t.includes("e-")){const[e,a]=t.split("e-");return parseInt(a,10)}return(null===(a=t.split(".")[1])||void 0===a?void 0:a.length)||0}var __importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const exchange_1=__importDefault(require("@b/utils/exchange")),db_1=require("@b/db"),query_1=require("@b/utils/query"),error_1=require("@b/utils/error"),emails_1=require("@b/utils/emails"),cache_1=require("@b/utils/cache"),console_1=require("@b/utils/console"),wallet_1=require("@b/services/wallet");exports.metadata={summary:"Performs a withdraw transaction",description:"Initiates a withdraw transaction for the currently authenticated user",operationId:"createWithdraw",tags:["Wallets"],requiresAuth:!0,logModule:"SPOT_WITHDRAW",logTitle:"Process spot withdrawal",requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{currency:{type:"string",description:"Currency to withdraw"},chain:{type:"string",description:"Withdraw method ID"},amount:{type:"number",description:"Amount to withdraw"},toAddress:{type:"string",description:"Withdraw toAddress"}},required:["currency","chain","amount","toAddress"]}}}},responses:{200:{description:"Withdraw transaction initiated successfully",content:{"application/json":{schema:{type:"object",properties:{message:{type:"string",description:"Success message"}}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Withdraw"),500:query_1.serverErrorResponse}};exports.default=async e=>{var a,t,r,n,i,s,o,l,d,c,u,w,f,h;const{user:p,body:m,ctx:g}=e;if(!(null==p?void 0:p.id)){null==g||g.fail("User not authenticated");throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"})}const{currency:b,chain:_,amount:y,toAddress:v,memo:E}=m;null==g||g.step("Validating withdrawal request parameters");if(!y||!v||!b){null==g||g.fail("Missing required fields: amount, toAddress, or currency");throw(0,error_1.createError)({statusCode:400,message:"Invalid input"})}null==g||g.step("Verifying user account");if(!await db_1.models.user.findByPk(p.id)){null==g||g.fail("User account not found");throw(0,error_1.createError)({statusCode:404,message:"User not found"})}null==g||g.step("Validating currency configuration");const C=await db_1.models.exchangeCurrency.findOne({where:{currency:b}});if(!C){null==g||g.fail(`Currency not found: ${b}`);throw(0,error_1.createError)({statusCode:404,message:"Currency not found"})}null==g||g.step("Connecting to exchange provider");const $=await exchange_1.default.startExchange(g),x=await exchange_1.default.getProvider();if(!$){null==g||g.fail("Exchange connection failed");throw(0,error_1.createError)(500,"Exchange not found")}null==g||g.step("Fetching exchange currency data");const I="xt"===x,T=await $.fetchCurrencies(),W=Object.values(T).find(e=>I?e.code===b:e.id===b);if(!W){null==g||g.fail(`Currency ${b} not available on exchange`);throw(0,error_1.createError)(404,`Currency ${b} is not available for withdrawal on the exchange. Please contact support if you believe this is an error.`)}null==g||g.step("Validating withdrawal amount and precision");const P=null!==(n=null!==(r=null!==(t=W.networks&&(null===(a=W.networks[_])||void 0===a?void 0:a.precision))&&void 0!==t?t:W.precision)&&void 0!==r?r:C.precision)&&void 0!==n?n:8,A=countDecimals(y);if(A>P){null==g||g.fail(`Amount exceeds precision: ${A} > ${P}`);throw(0,error_1.createError)({statusCode:400,message:`Amount has too many decimal places for ${b} on ${_}. Max allowed is ${P} decimal places. Your amount has ${A} decimal places.`})}const D=null!==(s=null===(i=W.networks)||void 0===i?void 0:i[_])&&void 0!==s?s:{},q=null!==(l=null!==(o=D.min_withdraw)&&void 0!==o?o:W.min_withdraw)&&void 0!==l?l:0,k=null!==(c=null!==(d=D.max_withdraw)&&void 0!==d?d:W.max_withdraw)&&void 0!==c?c:0;if(q&&y<q){null==g||g.fail(`Amount below minimum: ${y} < ${q}`);throw(0,error_1.createError)({statusCode:400,message:`Minimum withdrawal for ${b} on ${_} is ${q}`})}if(k&&y>k){null==g||g.fail(`Amount exceeds maximum: ${y} > ${k}`);throw(0,error_1.createError)({statusCode:400,message:`Maximum withdrawal for ${b} on ${_} is ${k}`})}const N=Math.abs(parseFloat(y));if(N<=0||isNaN(N)){null==g||g.fail("Invalid amount: must be positive number");throw(0,error_1.createError)({statusCode:400,message:"Amount must be a positive number"})}null==g||g.step("Calculating withdrawal fees");let S=0;W.networks&&W.networks[_]&&(S=W.networks[_].fee||(null===(u=W.networks[_].fees)||void 0===u?void 0:u.withdraw)||0);const O=C.fee||0,F=cache_1.CacheManager.getInstance(),L=await F.getSettings(),R=L.has("withdrawChainFee")&&"true"===L.get("withdrawChainFee"),M=O+parseFloat(L.get("spotWithdrawFee")||"0"),U=parseFloat(Math.max(N*M/100,0).toFixed(P)),G=R?0:S,j=parseFloat((N+U).toFixed(P)),V=parseFloat((N-G).toFixed(P));null==g||g.step("Processing withdrawal transaction");const B=await db_1.sequelize.transaction(async e=>{null==g||g.step("Locking user wallet for update");const a=await db_1.models.wallet.findOne({where:{userId:p.id,currency:b,type:"SPOT"},transaction:e,lock:e.LOCK.UPDATE});if(!a){null==g||g.fail(`${b} SPOT wallet not found`);throw(0,error_1.createError)({statusCode:404,message:`${b} wallet not found in your spot wallets. Please ensure you have a ${b} spot wallet before attempting withdrawal.`})}null==g||g.step("Checking wallet balance");if(a.balance<j){null==g||g.fail(`Insufficient balance: ${a.balance} < ${j}`);throw(0,error_1.createError)({statusCode:400,message:"Insufficient funds"})}const t=parseFloat((a.balance-j).toFixed(P));if(t<0){null==g||g.fail(`Calculated balance would be negative: ${t}`);throw(0,error_1.createError)({statusCode:400,message:"Insufficient funds"})}null==g||g.step("Deducting funds from wallet via wallet service");const r=`spot_withdraw_${p.id}_${b}_${N}`,n=await wallet_1.walletService.debit({idempotencyKey:r,userId:p.id,walletId:a.id,walletType:"SPOT",currency:b,amount:j,operationType:"WITHDRAW",description:`Withdrawal of ${N} ${b} (net: ${V}) to ${v} via ${_}`,metadata:{chain:_,toAddress:v,memo:E,totalAmount:N,netAmount:V,fee:U},transaction:e});a.balance=t;null==g||g.step("Recording admin profit from fees");const i=await db_1.models.adminProfit.create({amount:U,currency:a.currency,type:"WITHDRAW",transactionId:n.transactionId,chain:_,description:`Admin profit from user (${p.id}) withdrawal fee of ${U} ${a.currency} on ${_}`},{transaction:e});return{transactionId:n.transactionId,adminProfit:i,wallet:a}}),H=await db_1.models.transaction.findByPk(B.transactionId),K={...B,dbTransaction:H};null==g||g.step("Checking withdrawal approval settings");if(!(L.has("withdrawApproval")&&"true"===L.get("withdrawApproval"))){null==g||g.success(`Withdrawal request submitted for approval: ${N} ${b} to ${v} via ${_}`);return{message:"Withdrawal request submitted and pending approval",transaction:K.dbTransaction,currency:B.wallet.currency,method:_,balance:B.wallet.balance}}{null==g||g.step("Auto-approval enabled, proceeding with exchange withdrawal");let e,a="PENDING";const t=V;try{null==g||g.step("Validating exchange balance");let r;try{r=(await $.fetchBalance()).free[b]||0;if(r<t){null==g||g.fail(`Insufficient exchange balance: ${r} < ${t}`);throw(0,error_1.createError)({statusCode:400,message:`Insufficient exchange balance. Available: ${r} ${b}, Required: ${t} ${b}. Please contact support to refill the exchange account.`})}}catch(e){null==g||g.warn(`Could not verify exchange balance for ${b}`);console_1.logger.warn("WITHDRAW",`Could not fetch exchange balance for ${b}`,e)}null==g||g.step(`Executing withdrawal via ${x} exchange`);switch(x){case"kucoin":try{null==g||g.step("Transferring funds to trade account (KuCoin)");const r=await $.transfer(b,t,"main","trade");if(!r||!r.id){null==g||g.fail("Transfer to trade account failed");throw(0,error_1.createError)({statusCode:500,message:"Transfer to trade account failed"})}null==g||g.step("Initiating withdrawal to external address");e=await $.withdraw(b,t,v,E,{network:_});if(!e||!e.id){null==g||g.fail("Withdrawal response invalid from exchange");throw(0,error_1.createError)({statusCode:500,message:"Withdrawal response invalid"})}{null==g||g.step("Fetching withdrawal details");const t=(await $.fetchWithdrawals(b)).find(a=>a.id===e.id);if(t){e.fee=R?(null===(w=t.fee)||void 0===w?void 0:w.cost)||S:0;a="ok"===t.status?"COMPLETED":t.status.toUpperCase()}else{e.fee=R?S:0;a="COMPLETED"}}}catch(e){null==g||g.fail("KuCoin withdrawal failed: "+e.message);throw(0,error_1.createError)({statusCode:500,message:"Withdrawal request failed. Please try again or contact support."})}break;case"binance":case"kraken":case"okx":try{null==g||g.step("Initiating withdrawal to external address");e=await $.withdraw(b,t,v,E,{network:_});if(!e||!e.id){null==g||g.fail("Withdrawal response invalid from exchange");throw(0,error_1.createError)({statusCode:500,message:"Withdrawal response invalid"})}{null==g||g.step("Fetching withdrawal details");const t=(await $.fetchWithdrawals(b)).find(a=>a.id===e.id);if(t){e.fee=R?(null===(f=t.fee)||void 0===f?void 0:f.cost)||S:0;a="ok"===t.status?"COMPLETED":t.status.toUpperCase()}else{e.fee=R?S:0;a="COMPLETED"}}}catch(e){if(e.message&&e.message.includes("-4026")){null==g||g.fail("Exchange reported insufficient funds (error -4026)");throw(0,error_1.createError)({statusCode:400,message:"Insufficient funds available for withdrawal. Please try a smaller amount or contact support for assistance."})}if(e.message&&e.message.includes("insufficient")){null==g||g.fail("Exchange reported insufficient funds");throw(0,error_1.createError)({statusCode:400,message:"Insufficient funds available for withdrawal. Please contact support for assistance."})}null==g||g.fail(`${x} withdrawal failed: `+e.message);throw(0,error_1.createError)({statusCode:500,message:"Withdrawal request failed. Please try again or contact support."})}break;case"xt":try{null==g||g.step("Initiating withdrawal to external address");e=await $.withdraw(b,t,v,E,{network:_});if(!e||!e.id){null==g||g.fail("Withdrawal response invalid from exchange");throw(0,error_1.createError)({statusCode:500,message:"Withdrawal response invalid"})}{null==g||g.step("Fetching withdrawal details");const t=(await $.fetchWithdrawals(b)).find(a=>a.id===e.id);if(t){e.fee=R?(null===(h=t.fee)||void 0===h?void 0:h.cost)||S:0;a={SUCCESS:"COMPLETED",SUBMIT:"PENDING",REVIEW:"PENDING",AUDITED:"PROCESSING",AUDITED_AGAIN:"PROCESSING",PENDING:"PENDING",FAIL:"FAILED",CANCEL:"CANCELLED"}[t.status]||t.status.toUpperCase()}else{e.fee=R?S:0;a="COMPLETED"}}}catch(e){null==g||g.fail("XT withdrawal failed: "+e.message);throw(0,error_1.createError)({statusCode:500,message:"Withdrawal request failed. Please try again or contact support."})}break;default:null==g||g.fail(`Unsupported provider: ${x}`);throw(0,error_1.createError)({statusCode:400,message:"Withdrawal method not currently available. Please contact support."})}if(!e||!e.id||"FAILED"===a||"CANCELLED"===a){null==g||g.fail("Withdrawal failed or was cancelled by exchange");throw(0,error_1.createError)({statusCode:500,message:"Withdrawal failed"})}null==g||g.step("Updating transaction with exchange reference");await db_1.models.transaction.update({status:a,referenceId:e.id,metadata:JSON.stringify({...JSON.parse(K.dbTransaction.metadata),withdrawResponse:e})},{where:{id:K.dbTransaction.id}});null==g||g.step("Sending withdrawal confirmation email");const n=await db_1.models.user.findOne({where:{id:p.id}});n&&await(0,emails_1.sendTransactionStatusUpdateEmail)(n,K.dbTransaction,B.wallet,B.wallet.balance,null);null==g||g.success(`Withdrawn ${N} ${b} (net: ${V}) to ${v} via ${_}`);return{message:"Withdrawal completed successfully",transaction:K.dbTransaction,currency:B.wallet.currency,method:_,balance:B.wallet.balance}}catch(e){null==g||g.step("Rolling back transaction due to exchange error");await db_1.sequelize.transaction(async a=>{null==g||g.step("Cancelling transaction record");await db_1.models.transaction.update({status:"CANCELLED",metadata:JSON.stringify({...JSON.parse(K.dbTransaction.metadata),error:e.message})},{where:{id:K.dbTransaction.id},transaction:a});null==g||g.step("Refunding user wallet via wallet service");const t=`spot_withdraw_refund_${K.dbTransaction.id}`;await wallet_1.walletService.credit({idempotencyKey:t,userId:p.id,walletId:B.wallet.id,walletType:"SPOT",currency:b,amount:j,operationType:"REFUND_WITHDRAWAL",referenceId:K.dbTransaction.id,description:`Refund for failed withdrawal ${K.dbTransaction.id}`,metadata:{originalTransactionId:K.dbTransaction.id,reason:e.message},transaction:a});null==g||g.step("Removing admin profit record");await db_1.models.adminProfit.destroy({where:{id:B.adminProfit.id},transaction:a})});null==g||g.fail("Withdrawal failed: "+e.message);throw(0,error_1.createError)(500,"Withdrawal failed: "+e.message)}}};