"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const query_1=require("@b/utils/query"),utils_1=require("./utils"),error_1=require("@b/utils/error");exports.metadata={summary:"Retrieves details of a specific wallet",description:"Fetches detailed information about a specific wallet based on its unique identifier.",operationId:"getWallet",tags:["Finance","Wallets"],requiresAuth:!0,parameters:[{in:"query",name:"type",required:!0,schema:{type:"string",enum:["ECO","SPOT"]},description:"The type of wallet to retrieve"},{in:"query",name:"currency",required:!0,schema:{type:"string"},description:"The currency of the wallet to retrieve"},{in:"query",name:"pair",required:!0,schema:{type:"string"},description:"The pair of the wallet to retrieve"}],responses:{200:{description:"Wallet details retrieved successfully"},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Wallet"),500:query_1.serverErrorResponse}};exports.default=async e=>{const{user:r,query:t,ctx:i}=e;if(!r)throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});const{type:a,currency:l,pair:s}=t;null==i||i.step(`Fetching wallet balances for ${l}/${s}`);const n=await(0,utils_1.getWalletSafe)(r.id,a,l),u=await(0,utils_1.getWalletSafe)(r.id,a,s),o={balance:(null==n?void 0:n.balance)||0,inOrder:(null==n?void 0:n.inOrder)||0,total:((null==n?void 0:n.balance)||0)+((null==n?void 0:n.inOrder)||0)},c={balance:(null==u?void 0:u.balance)||0,inOrder:(null==u?void 0:u.inOrder)||0,total:((null==u?void 0:u.balance)||0)+((null==u?void 0:u.inOrder)||0)};null==i||i.success("Wallet balances retrieved successfully");return{CURRENCY:o,PAIR:c}};