"use strict";async function processFiatDeposit({userId:e,currency:t,amount:a,fee:n,referenceId:o,method:i,description:l,metadata:r,idempotencyKey:d,ctx:c}){var s,u,p;null===(s=null==c?void 0:c.step)||void 0===s||s.call(c,"Processing fiat deposit via wallet service");const w=await wallet_1.walletCreationService.getOrCreateWallet(e,"FIAT",t),f=d||`fiat_deposit_${o}`,m=a-n,v=await wallet_1.walletService.credit({idempotencyKey:f,userId:e,walletId:w.id,walletType:"FIAT",currency:t,amount:m,operationType:"DEPOSIT",fee:n,referenceId:o,description:l||`Deposit of ${a} ${t} via ${i}`,metadata:{method:i,originalAmount:a,fee:n,...r}});if(n>0){null===(u=null==c?void 0:c.step)||void 0===u||u.call(c,"Recording admin profit");await db_1.models.adminProfit.create({amount:n,currency:t,type:"DEPOSIT",transactionId:v.transactionId,description:`Admin profit from ${i} deposit fee of ${n} ${t} for user (${e})`})}null===(p=null==c?void 0:c.success)||void 0===p||p.call(c,`Fiat deposit completed: ${m} ${t}`);return{transactionId:v.transactionId,walletId:v.walletId,newBalance:v.newBalance,amount:m,fee:n,currency:t}}async function processSpotDeposit({userId:e,currency:t,amount:a,fee:n,referenceId:o,chain:i,description:l,metadata:r,idempotencyKey:d,ctx:c}){var s,u,p;null===(s=null==c?void 0:c.step)||void 0===s||s.call(c,"Processing spot deposit via wallet service");const w=await wallet_1.walletCreationService.getOrCreateWallet(e,"SPOT",t),f=d||`spot_deposit_${o}`,m=a-n,v=await wallet_1.walletService.credit({idempotencyKey:f,userId:e,walletId:w.id,walletType:"SPOT",currency:t,amount:m,operationType:"DEPOSIT",fee:n,referenceId:o,description:l||`Deposit of ${a} ${t} via ${i}`,metadata:{chain:i,originalAmount:a,fee:n,...r}});if(n>0){null===(u=null==c?void 0:c.step)||void 0===u||u.call(c,"Recording admin profit");await db_1.models.adminProfit.create({amount:n,currency:t,type:"DEPOSIT",transactionId:v.transactionId,chain:i,description:`Admin profit from spot deposit fee of ${n} ${t} on ${i} for user (${e})`})}null===(p=null==c?void 0:c.success)||void 0===p||p.call(c,`Spot deposit completed: ${m} ${t}`);return{transactionId:v.transactionId,walletId:v.walletId,newBalance:v.newBalance,amount:m,fee:n,currency:t}}async function processSpotWithdrawal({userId:e,currency:t,amount:a,fee:n,toAddress:o,chain:i,memo:l,description:r,metadata:d,idempotencyKey:c,ctx:s}){var u,p,w,f;null===(u=null==s?void 0:s.step)||void 0===u||u.call(s,"Processing spot withdrawal via wallet service");const m=await db_1.models.wallet.findOne({where:{userId:e,currency:t,type:"SPOT"}});if(!m){null===(p=null==s?void 0:s.fail)||void 0===p||p.call(s,`${t} SPOT wallet not found`);throw new wallet_1.WalletError("WALLET_NOT_FOUND",`${t} wallet not found in your spot wallets`)}const v=a+n,y=await wallet_1.walletService.debit({idempotencyKey:c,userId:e,walletId:m.id,walletType:"SPOT",currency:t,amount:v,operationType:"WITHDRAW",fee:n,description:r||`Withdrawal of ${a} ${t} to ${o} via ${i}`,metadata:{chain:i,toAddress:o,memo:l,originalAmount:a,fee:n,...d}});if(n>0){null===(w=null==s?void 0:s.step)||void 0===w||w.call(s,"Recording admin profit");await db_1.models.adminProfit.create({amount:n,currency:t,type:"WITHDRAW",transactionId:y.transactionId,chain:i,description:`Admin profit from user (${e}) withdrawal fee of ${n} ${t} on ${i}`})}null===(f=null==s?void 0:s.success)||void 0===f||f.call(s,`Spot withdrawal initiated: ${a} ${t}`);return{transactionId:y.transactionId,walletId:y.walletId,newBalance:y.newBalance,amount:a,fee:n,currency:t}}async function refundSpotWithdrawal({userId:e,currency:t,amount:a,fee:n,originalTransactionId:o,reason:i,idempotencyKey:l,ctx:r}){var d,c,s;null===(d=null==r?void 0:r.step)||void 0===d||d.call(r,"Processing withdrawal refund via wallet service");const u=await db_1.models.wallet.findOne({where:{userId:e,currency:t,type:"SPOT"}});if(!u){null===(c=null==r?void 0:r.fail)||void 0===c||c.call(r,`${t} SPOT wallet not found for refund`);throw new wallet_1.WalletError("WALLET_NOT_FOUND",`${t} wallet not found`)}const p=a+n,w=await wallet_1.walletService.credit({idempotencyKey:l,userId:e,walletId:u.id,walletType:"SPOT",currency:t,amount:p,operationType:"REFUND_WITHDRAWAL",description:`Refund of failed withdrawal: ${i}`,metadata:{originalTransactionId:o,reason:i,originalAmount:a,originalFee:n}});null===(s=null==r?void 0:r.success)||void 0===s||s.call(r,`Withdrawal refund completed: ${p} ${t}`);return{transactionId:w.transactionId,walletId:w.walletId,newBalance:w.newBalance,amount:p,currency:t}}async function processEcoDeposit({userId:e,currency:t,amount:a,fee:n,referenceId:o,chain:i,description:l,metadata:r,idempotencyKey:d,ctx:c}){var s,u,p;null===(s=null==c?void 0:c.step)||void 0===s||s.call(c,"Processing ECO deposit via wallet service");const w=await wallet_1.walletCreationService.getOrCreateWallet(e,"ECO",t),f=d||`eco_deposit_${o}`,m=a-n,v=await wallet_1.walletService.credit({idempotencyKey:f,userId:e,walletId:w.id,walletType:"ECO",currency:t,amount:m,operationType:"DEPOSIT",fee:n,referenceId:o,description:l||`ECO Deposit of ${a} ${t} via ${i}`,metadata:{chain:i,originalAmount:a,fee:n,...r}});if(n>0){null===(u=null==c?void 0:c.step)||void 0===u||u.call(c,"Recording admin profit");await db_1.models.adminProfit.create({amount:n,currency:t,type:"DEPOSIT",transactionId:v.transactionId,chain:i,description:`Admin profit from ECO deposit fee of ${n} ${t} on ${i} for user (${e})`})}null===(p=null==c?void 0:c.success)||void 0===p||p.call(c,`ECO deposit completed: ${m} ${t}`);return{transactionId:v.transactionId,walletId:v.walletId,newBalance:v.newBalance,amount:m,fee:n,currency:t}}async function processEcoWithdrawal({userId:e,currency:t,amount:a,fee:n,toAddress:o,chain:i,memo:l,description:r,metadata:d,idempotencyKey:c,ctx:s}){var u,p,w,f;null===(u=null==s?void 0:s.step)||void 0===u||u.call(s,"Processing ECO withdrawal via wallet service");const m=await db_1.models.wallet.findOne({where:{userId:e,currency:t,type:"ECO"}});if(!m){null===(p=null==s?void 0:s.fail)||void 0===p||p.call(s,`${t} ECO wallet not found`);throw new wallet_1.WalletError("WALLET_NOT_FOUND",`${t} ECO wallet not found`)}const v=a+n,y=await wallet_1.walletService.debit({idempotencyKey:c,userId:e,walletId:m.id,walletType:"ECO",currency:t,amount:v,operationType:"WITHDRAW",fee:n,description:r||`ECO Withdrawal of ${a} ${t} to ${o} via ${i}`,metadata:{chain:i,toAddress:o,memo:l,originalAmount:a,fee:n,...d}});if(n>0){null===(w=null==s?void 0:s.step)||void 0===w||w.call(s,"Recording admin profit");await db_1.models.adminProfit.create({amount:n,currency:t,type:"WITHDRAW",transactionId:y.transactionId,chain:i,description:`Admin profit from ECO withdrawal fee of ${n} ${t} on ${i} for user (${e})`})}null===(f=null==s?void 0:s.success)||void 0===f||f.call(s,`ECO withdrawal initiated: ${a} ${t}`);return{transactionId:y.transactionId,walletId:y.walletId,newBalance:y.newBalance,amount:a,fee:n,currency:t}}async function updateTransaction(e,t,a){var n,o,i,l;null===(n=null==a?void 0:a.step)||void 0===n||n.call(a,`Updating transaction ${e}`);await db_1.models.transaction.update({...t},{where:{id:e}});null===(o=null==a?void 0:a.step)||void 0===o||o.call(a,`Fetching updated transaction ${e}`);const r=await db_1.models.transaction.findByPk(e,{include:[{model:db_1.models.wallet,as:"wallet",attributes:["id","currency"]},{model:db_1.models.user,as:"user",attributes:["id","firstName","lastName","email","avatar"]}]});if(!r){null===(i=null==a?void 0:a.fail)||void 0===i||i.call(a,"Transaction not found");throw(0,error_1.createError)({statusCode:404,message:"Transaction not found"})}null===(l=null==a?void 0:a.success)||void 0===l||l.call(a,`Transaction ${e} updated successfully`);return r.get({plain:!0})}Object.defineProperty(exports,"__esModule",{value:!0});exports.processFiatDeposit=processFiatDeposit;exports.processSpotDeposit=processSpotDeposit;exports.processSpotWithdrawal=processSpotWithdrawal;exports.refundSpotWithdrawal=refundSpotWithdrawal;exports.processEcoDeposit=processEcoDeposit;exports.processEcoWithdrawal=processEcoWithdrawal;exports.updateTransaction=updateTransaction;const db_1=require("@b/db"),wallet_1=require("@b/services/wallet"),error_1=require("@b/utils/error");