"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),query_1=require("@b/utils/query"),console_1=require("@b/utils/console");exports.metadata={summary:"Validate recipient for transfer",description:"Validates if a recipient UUID exists for transfer operations",operationId:"validateTransferRecipient",tags:["Finance","Transfer"],requiresAuth:!0,parameters:[{name:"uuid",in:"query",required:!0,schema:{type:"string",description:"The UUID of the recipient to validate"}}],responses:{200:{description:"Recipient validation result",content:{"application/json":{schema:{type:"object",properties:{exists:{type:"boolean",description:"Whether the recipient exists"},recipient:{type:"object",description:"Recipient information if found",properties:{id:{type:"string"},firstName:{type:"string"},lastName:{type:"string"},email:{type:"string"}}}}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Recipient"),500:query_1.serverErrorResponse}};exports.default=async e=>{const{user:t,query:r}=e;if(!(null==t?void 0:t.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});const{uuid:i}=r;if(!i||"string"!=typeof i)throw(0,error_1.createError)({statusCode:400,message:"Recipient UUID is required"});if(!/^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$/i.test(i))return{exists:!1,message:"Invalid UUID format"};try{const e=await db_1.models.user.findOne({where:{id:i},attributes:["id","firstName","lastName","email","status"]});return e?e.id===t.id?{exists:!1,message:"Cannot transfer to yourself"}:"ACTIVE"!==e.status?{exists:!1,message:"Recipient account is inactive"}:{exists:!0,recipient:{id:e.id,firstName:e.firstName,lastName:e.lastName,email:e.email}}:{exists:!1,message:"Recipient not found"}}catch(e){console_1.logger.error("TRANSFER","Error validating recipient",e);throw(0,error_1.createError)({statusCode:500,message:"Failed to validate recipient"})}};