"use strict";async function getWalletByUserIdAndCurrency(e,r){const t=await(0,safe_imports_1.getEcosystemWalletUtils)();if(!(0,safe_imports_1.isServiceAvailable)(t))throw(0,error_1.createError)({statusCode:503,message:"Ecosystem wallet extension is not installed or available"});if("function"!=typeof t.getWalletByUserIdAndCurrency)throw(0,error_1.createError)({statusCode:500,message:"getWalletByUserIdAndCurrency function not found"});return t.getWalletByUserIdAndCurrency(e,r)}async function handleClientTransfer(e,r,t){if(!e)throw(0,error_1.createError)({statusCode:400,message:"Client ID is required"});const a=await db_1.models.user.findByPk(e);if(!a)throw(0,error_1.createError)({statusCode:404,message:"Target user not found"});let n;if("ECO"===t)try{n=await getWalletByUserIdAndCurrency(e,r)}catch(a){console_1.logger.warn("TRANSFER","ECO extension not available, falling back to regular wallet",a);n=(await wallet_1.walletCreationService.getOrCreateWallet(e,t,r)).wallet}else{n=(await wallet_1.walletCreationService.getOrCreateWallet(e,t,r)).wallet}if(!n)throw(0,error_1.createError)({statusCode:404,message:"Target wallet not found"});return{toWallet:n,toUser:a}}async function handleWalletTransfer(e,r,t,a){const n=cache_1.CacheManager.getInstance(),o=await n.getSetting("spotWallets"),s=!0===o||"true"===o;if(!s&&("SPOT"===r||"SPOT"===t))throw(0,error_1.createError)(400,"Spot wallet transfers are currently disabled");const l={FIAT:s?["SPOT","ECO"]:["ECO"],SPOT:["FIAT","ECO"],ECO:s?["FIAT","SPOT","FUTURES"]:["FIAT","FUTURES"],FUTURES:["ECO"]};if(!l[r]||!l[r].includes(t))throw(0,error_1.createError)(400,"Invalid wallet type transfer");if("FUTURES"===r&&"ECO"!==t)throw(0,error_1.createError)(400,"FUTURES wallet can only transfer to ECO wallet");return(await wallet_1.walletCreationService.getOrCreateWallet(e,t,a)).wallet}async function performTransaction(e,r,t,a,n,o,s,l,i,c,d){const u=cache_1.CacheManager.getInstance(),f=(await u.getSettings()).get("walletTransferFeePercentage")||0,g=(0,utils_1.calculateTransferFee)(a,f);let p=a-g;if(n!==o){console_1.logger.info("TRANSFER",`Calculating exchange rate from ${n} to ${o}`);const e=await getExchangeRate(n,i,o,c);p=(a-g)*e;console_1.logger.info("TRANSFER",`Converted amount: ${a-g} ${n} = ${p} ${o} (rate: ${e})`)}const w=a;if(r.balance<w)throw(0,error_1.createError)(400,"Insufficient balance to cover transfer and fees.");return await db_1.sequelize.transaction(async o=>{console_1.logger.info("TRANSFER","Starting database transaction");const l=(0,utils_1.requiresPrivateLedgerUpdate)(e,i,c),u=l?"PENDING":"COMPLETED";console_1.logger.info("TRANSFER",`Transfer status: ${u} (ledger update required: ${l})`);let f;if(l){console_1.logger.info("TRANSFER","Processing pending transfer (ledger update required)");f=await handlePendingTransfer({fromWallet:r,toWallet:t,totalDeducted:w,targetReceiveAmount:p,transferStatus:u,currencyData:d,t:o})}else{console_1.logger.info("TRANSFER","Processing complete transfer (no ledger update required)");f=await handleCompleteTransfer({fromWallet:r,toWallet:t,parsedAmount:a,targetReceiveAmount:p,transferType:e,fromType:i,fromCurrency:n,currencyData:d,t:o})}console_1.logger.info("TRANSFER","Retrieving transaction records");const y=await db_1.models.transaction.findByPk(f.fromTransactionId,{transaction:o}),T=f.toTransactionId?await db_1.models.transaction.findByPk(f.toTransactionId,{transaction:o}):null;if(!y)throw(0,error_1.createError)({statusCode:500,message:"Failed to retrieve outgoing transaction record"});if(g>0){console_1.logger.info("TRANSFER",`Recording admin profit: ${g} ${n}`);await(0,utils_1.recordAdminProfit)({userId:s,transferFeeAmount:g,fromCurrency:n,fromType:i,toType:c,transactionId:f.fromTransactionId,t:o})}console_1.logger.info("TRANSFER","Database transaction completed successfully");return{fromTransfer:y,toTransfer:T}})}async function getExchangeRate(e,r,t,a){try{let n,o;switch(r){case"FIAT":n=await(0,utils_2.getFiatPriceInUSD)(e);break;case"SPOT":n=await(0,utils_2.getSpotPriceInUSD)(e);break;case"ECO":case"FUTURES":n=await(0,utils_2.getEcoPriceInUSD)(e);break;default:throw(0,error_1.createError)(400,`Invalid fromType: ${r}`)}switch(a){case"FIAT":o=await(0,utils_2.getFiatPriceInUSD)(t);break;case"SPOT":o=await(0,utils_2.getSpotPriceInUSD)(t);break;case"ECO":case"FUTURES":o=await(0,utils_2.getEcoPriceInUSD)(t);break;default:throw(0,error_1.createError)(400,`Invalid toType: ${a}`)}if(!n||n<=0)throw(0,error_1.createError)(400,`Price not available for ${e} in ${r} wallet`);if(!o||o<=0)throw(0,error_1.createError)(400,`Price not available for ${t} in ${a} wallet`);return n/o}catch(r){if(r.statusCode)throw r;throw(0,error_1.createError)(400,`Unable to fetch exchange rate between ${e} and ${t}: ${r.message}`)}}async function handleCompleteTransfer({fromWallet:e,toWallet:r,parsedAmount:t,targetReceiveAmount:a,transferType:n,fromType:o,fromCurrency:s,currencyData:l,t:i}){if("ECO"===o&&"client"===n){console_1.logger.info("TRANSFER","Handling ECO client balance transfer");return await handleEcoClientBalanceTransfer({fromWallet:e,toWallet:r,parsedAmount:t,fromCurrency:s,currencyData:l,t:i})}console_1.logger.info("TRANSFER","Handling non-client transfer");return await handleNonClientTransfer({fromWallet:e,toWallet:r,parsedAmount:t,fromCurrency:s,targetReceiveAmount:a,currencyData:l,t:i})}async function handleEcoClientBalanceTransfer({fromWallet:e,toWallet:r,parsedAmount:t,fromCurrency:a,currencyData:n,t:o}){console_1.logger.info("TRANSFER","Parsing ECO wallet addresses");const s=parseAddresses(e.address),l=parseAddresses(r.address);console_1.logger.info("TRANSFER",`Distributing ${t} ${a} across chains`);let i=t;for(const[t,n]of(0,utils_1.getSortedChainBalances)(s)){if(i<=0)break;const s=Math.min(n.balance,i);console_1.logger.info("TRANSFER",`Transferring ${s} from chain: ${t}`);n.balance-=s;l[t]=l[t]||{balance:0};l[t].balance+=s;console_1.logger.info("TRANSFER",`Updating private ledger for sender wallet on chain: ${t}`);await(0,utils_1.updatePrivateLedger)(e.id,0,a,t,-s,o);console_1.logger.info("TRANSFER",`Updating private ledger for recipient wallet on chain: ${t}`);await(0,utils_1.updatePrivateLedger)(r.id,0,a,t,s,o);i-=s}if(i>0){console_1.logger.error("TRANSFER",`Insufficient chain balance: ${i} ${a} remaining`);throw(0,error_1.createError)(400,"Insufficient chain balance across all addresses.")}console_1.logger.info("TRANSFER","Updating wallet balances");return await(0,utils_1.updateWalletBalances)(e,r,t,t,n.precision,o,`transfer_eco_client_${e.id}_${r.id}`)}async function handleNonClientTransfer({fromWallet:e,toWallet:r,parsedAmount:t,fromCurrency:a,targetReceiveAmount:n,currencyData:o,t:s}){if("ECO"===e.type&&"ECO"===r.type){console_1.logger.info("TRANSFER","Processing ECO to ECO wallet transfer");console_1.logger.info("TRANSFER","Deducting from source ECO wallet");const n=await deductFromEcoWallet(e,t,a,s);console_1.logger.info("TRANSFER","Adding to destination ECO wallet");await addToEcoWallet(r,n,a,s)}console_1.logger.info("TRANSFER",`Updating wallet balances (deduct: ${t}, add: ${n})`);return await(0,utils_1.updateWalletBalances)(e,r,t,n,o.precision,s,`transfer_non_client_${e.id}_${r.id}`)}async function deductFromEcoWallet(e,r,t,a){console_1.logger.info("TRANSFER",`Deducting ${r} ${t} from ECO wallet`);const n=parseAddresses(e.address);let o=r;const s=[];for(const r in n)if(Object.prototype.hasOwnProperty.call(n,r)&&n[r].balance>0){const a=Math.min(n[r].balance,o);console_1.logger.info("TRANSFER",`Deducting ${a} ${t} from chain: ${r}`);n[r].balance-=a;s.push({chain:r,amount:a});console_1.logger.info("TRANSFER",`Updating private ledger for deduction on chain: ${r}`);await(0,utils_1.updatePrivateLedger)(e.id,0,t,r,-a);o-=a;if(o<=0)break}if(o>0){console_1.logger.error("TRANSFER",`Insufficient chain balance: ${o} ${t} remaining`);throw(0,error_1.createError)(400,"Insufficient chain balance to complete the transfer")}console_1.logger.info("TRANSFER","Updating wallet address data");await e.update({address:JSON.stringify(n)},{transaction:a});console_1.logger.info("TRANSFER",`Successfully deducted from ${s.length} chain(s)`);return s}async function addToEcoWallet(e,r,t,a){console_1.logger.info("TRANSFER",`Adding to ECO wallet across ${r.length} chain(s)`);const n=parseAddresses(e.address);for(const a of r){const{chain:r,amount:o}=a;console_1.logger.info("TRANSFER",`Adding ${o} ${t} to chain: ${r}`);if(!n[r]){console_1.logger.info("TRANSFER",`Initializing new chain entry: ${r}`);n[r]={address:null,network:null,balance:0}}n[r].balance+=o;console_1.logger.info("TRANSFER",`Updating private ledger for addition on chain: ${r}`);await(0,utils_1.updatePrivateLedger)(e.id,0,t,r,o)}console_1.logger.info("TRANSFER","Updating wallet address data");await e.update({address:JSON.stringify(n)},{transaction:a});console_1.logger.info("TRANSFER","Successfully added to ECO wallet")}async function handlePendingTransfer({fromWallet:e,toWallet:r,totalDeducted:t,targetReceiveAmount:a,transferStatus:n,currencyData:o,t:s}){const l=`pending_transfer_${e.id}_${r.id}_${t}`;console_1.logger.info("TRANSFER",`Debiting source wallet (current: ${e.balance}, deducting: ${t})`);const i=await wallet_1.walletService.debit({idempotencyKey:`${l}_from`,userId:e.userId,walletId:e.id,walletType:e.type,currency:e.currency,amount:t,operationType:"OUTGOING_TRANSFER",description:`Transfer to wallet ${r.id}`,relatedWalletId:r.id,metadata:{targetWalletId:r.id,targetAmount:a,transferStatus:n},transaction:s});let c=null;if("COMPLETED"===n){console_1.logger.info("TRANSFER",`Crediting destination wallet (current: ${r.balance}, adding: ${a})`);c=(await wallet_1.walletService.credit({idempotencyKey:`${l}_to`,userId:r.userId,walletId:r.id,walletType:r.type,currency:r.currency,amount:a,operationType:"INCOMING_TRANSFER",description:`Transfer from wallet ${e.id}`,relatedWalletId:e.id,metadata:{sourceWalletId:e.id,sourceAmount:t},transaction:s})).transactionId}else console_1.logger.info("TRANSFER","Transfer is pending, destination wallet balance not updated yet");return{fromTransactionId:i.transactionId,toTransactionId:c}}function parseAddresses(e){if(!e)return{};if("string"==typeof e)try{return JSON.parse(e)}catch(e){console_1.logger.error("TRANSFER","Failed to parse address JSON",e);return{}}return"object"==typeof e?e:{}}async function processInternalTransfer(e,r,t,a,n){const o=await db_1.models.wallet.findOne({where:{userId:e,currency:t,type:"ECO"}});if(!o)throw(0,error_1.createError)({statusCode:404,message:"Sender wallet not found"});const s=(await wallet_1.walletCreationService.getOrCreateWallet(r,"ECO",t)).wallet,l="string"==typeof n?parseFloat(n):n;if(o.balance<l)throw(0,error_1.createError)(400,"Insufficient balance.");const i=cache_1.CacheManager.getInstance(),c=(await i.getSettings()).get("walletTransferFeePercentage")||0,d=l*c/100,u=l-d,f=await db_1.sequelize.transaction(async a=>{let n=8;if("ECO"===o.type&&"ECO"===s.type){const e=await deductFromEcoWallet(o,l,t,a);await addToEcoWallet(s,e,t,a);n=(await(0,utils_1.getCurrencyData)(o.type,o.currency)).precision}await(0,utils_1.updateWalletBalances)(o,s,l,u,n,a,`transfer_${o.id}_${s.id}`);const i=await(0,utils_1.createTransferTransaction)(e,o.id,"OUTGOING_TRANSFER",l,d,t,t,o.id,s.id,`Internal transfer to user ${r}`,"COMPLETED",a),c=await(0,utils_1.createTransferTransaction)(r,s.id,"INCOMING_TRANSFER",u,0,t,t,o.id,s.id,`Internal transfer from user ${e}`,"COMPLETED",a);d>0&&await(0,utils_1.recordAdminProfit)({userId:e,transferFeeAmount:d,fromCurrency:t,fromType:"ECO",toType:"ECO",transactionId:i.id,t:a});return{outgoingTransfer:i,incomingTransfer:c}}),g=await db_1.models.wallet.findOne({where:{userId:e,currency:t,type:"ECO"}});return{transaction:f,balance:null==g?void 0:g.balance,method:a,currency:t}}Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;exports.parseAddresses=parseAddresses;exports.processInternalTransfer=processInternalTransfer;const db_1=require("@b/db"),query_1=require("@b/utils/query"),error_1=require("@b/utils/error"),safe_imports_1=require("@b/utils/safe-imports"),console_1=require("@b/utils/console"),wallet_1=require("@b/services/wallet"),utils_1=require("./utils"),cache_1=require("@b/utils/cache"),utils_2=require("../currency/utils");exports.metadata={summary:"Performs a transfer transaction",description:"Initiates a transfer transaction for the currently authenticated user",operationId:"createTransfer",tags:["Finance","Transfer"],requiresAuth:!0,logModule:"TRANSFER",logTitle:"Process transfer transaction",requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{fromType:{type:"string",description:"The type of wallet to transfer from"},toType:{type:"string",description:"The type of wallet to transfer to"},fromCurrency:{type:"string",description:"The currency to transfer from"},toCurrency:{type:"string",description:"The currency to transfer to",nullable:!0},amount:{type:"number",description:"Amount to transfer"},transferType:{type:"string",description:"Type of transfer: client or wallet"},clientId:{type:"string",description:"Client UUID for client transfers",nullable:!0}},required:["fromType","toType","amount","fromCurrency","transferType"]}}}},responses:{200:{description:"Transfer transaction initiated successfully",content:{"application/json":{schema:{type:"object",properties:{message:{type:"string",description:"Success message"}}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Withdraw Method"),500:query_1.serverErrorResponse}};exports.default=async e=>{const{user:r,body:t,ctx:a}=e;if(!(null==r?void 0:r.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});null==a||a.step("Parsing transfer request parameters");const{fromType:n,toType:o,amount:s,transferType:l,clientId:i,fromCurrency:c,toCurrency:d}=t;null==a||a.step("Validating transfer request");if("Select a currency"===d){null==a||a.fail("Invalid target currency selected");throw(0,error_1.createError)({statusCode:400,message:"Please select a target currency"})}if("wallet"===l&&n===o){null==a||a.fail("Cannot transfer between same wallet type");throw(0,error_1.createError)({statusCode:400,message:"Wallet transfers must be between different wallet types"})}null==a||a.step("Verifying user exists in database");if(!await db_1.models.user.findByPk(r.id)){null==a||a.fail("User not found");throw(0,error_1.createError)({statusCode:404,message:"User not found"})}null==a||a.step(`Fetching source wallet (${c} ${n})`);const u=await db_1.models.wallet.findOne({where:{userId:r.id,currency:c,type:n}});if(!u){null==a||a.fail("Source wallet not found");throw(0,error_1.createError)({statusCode:404,message:"Wallet not found"})}let f=null,g=null;if("client"===l){null==a||a.step("Resolving destination wallet for client transfer");({toWallet:f,toUser:g}=await handleClientTransfer(i,d||c,o||n))}else{null==a||a.step("Resolving destination wallet for wallet-to-wallet transfer");f=await handleWalletTransfer(r.id,n,o,d)}null==a||a.step("Validating transfer amount");const p=parseFloat(s);if(isNaN(p)||p<=0){null==a||a.fail("Invalid transfer amount");throw(0,error_1.createError)(400,"Invalid transfer amount")}null==a||a.step("Fetching currency data");const w=await(0,utils_1.getCurrencyData)(n,c);if(!w){null==a||a.fail("Invalid wallet type");throw(0,error_1.createError)(400,"Invalid wallet type")}null==a||a.step("Calculating transfer fees");const y=cache_1.CacheManager.getInstance(),T=(await y.getSettings()).get("walletTransferFeePercentage")||0,_=((0,utils_1.calculateTransferFee)(p,T),p);null==a||a.step("Checking source wallet balance");if(u.balance<_){null==a||a.fail(`Insufficient balance: ${u.balance} < ${_}`);throw(0,error_1.createError)(400,"Insufficient balance to cover transfer")}null==a||a.step("Executing transfer transaction");const m=await performTransaction(l,u,f,p,c,d,r.id,null==g?void 0:g.id,n,o,w);if("client"===l){null==a||a.step("Sending transfer notification emails");const e=await db_1.models.user.findByPk(r.id);await(0,utils_1.sendTransferEmails)(e,g,u,f,p,m)}null==a||a.success(`Transfer completed: ${p} ${c} from ${n} to ${d||c} ${o}`);return{message:"Transfer initiated successfully",fromTransfer:m.fromTransfer,toTransfer:m.toTransfer,fromType:n,toType:o,fromCurrency:c,toCurrency:d}};