"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const emails_1=require("@b/utils/emails"),db_1=require("@b/db"),error_1=require("@b/utils/error"),query_1=require("@b/utils/query"),utils_1=require("../wallet/utils"),date_1=require("@b/utils/date"),wallet_1=require("@b/services/wallet"),cache_1=require("@b/utils/cache"),affiliate_1=require("@b/utils/affiliate");exports.metadata={summary:"Creates a new investment",description:"Initiates a new investment based on the specified plan and amount. This process involves updating the user's wallet balance and creating transaction records.",operationId:"createInvestment",tags:["Finance","Investment"],logModule:"FINANCE",logTitle:"Create investment",parameters:[],requestBody:{description:"Data required to create a new investment",content:{"application/json":{schema:{type:"object",properties:{type:{type:"string",description:"The type of investment plan",example:"general"},planId:{type:"string",description:"The unique identifier of the investment plan",example:"1"},amount:{type:"number",description:"Investment amount",example:1e3},durationId:{type:"string",description:"The unique identifier of the investment duration",example:"1"}},required:["type","planId","durationId","amount"]}}}},responses:(0,query_1.createRecordResponses)("Investment"),requiresAuth:!0};exports.default=async e=>{const{user:t,body:n,ctx:a}=e;if(!(null==t?void 0:t.id)){null==a||a.fail("User not authenticated");throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"})}const r=cache_1.CacheManager.getInstance();if(!("true"===await r.getSetting("investment")))throw(0,error_1.createError)({statusCode:403,message:"Investment feature is currently disabled"});const{type:i,planId:s,amount:l,durationId:o}=n;null==a||a.step("Fetching user account");const d=await db_1.models.user.findByPk(t.id);if(!d){null==a||a.fail("User account not found");throw(0,error_1.createError)({statusCode:404,message:"User not found"})}null==a||a.step("Validating investment type");if(!i||"string"!=typeof i){null==a||a.fail(`Invalid investment type: ${i}`);throw(0,error_1.createError)({statusCode:400,message:"Invalid investment type"})}null==a||a.step(`Initializing ${i} investment models`);let u,c,m,p,f;switch(i.toLowerCase()){case"general":u=db_1.models.investment;c=db_1.models.investmentPlan;m=db_1.models.investmentDuration;p="INVESTMENT";f="NewInvestmentCreated";break;case"forex":u=db_1.models.forexInvestment;c=db_1.models.forexPlan;m=db_1.models.forexDuration;p="FOREX_INVESTMENT";f="NewForexInvestmentCreated"}if(!u){null==a||a.fail(`Invalid investment type: ${i}`);throw(0,error_1.createError)({statusCode:400,message:"Invalid investment type"})}null==a||a.step("Fetching investment plan");const v=await c.findByPk(s);if(!v){null==a||a.fail(`Investment plan not found: ${s}`);throw(0,error_1.createError)({statusCode:404,message:"Investment plan not found"})}null==a||a.step("Fetching investment duration");const y=await m.findByPk(o);if(!y){null==a||a.fail(`Investment duration not found: ${o}`);throw(0,error_1.createError)({statusCode:404,message:"Investment duration not found"})}null==a||a.step(`Fetching ${v.currency} ${v.walletType} wallet`);const I=await(0,utils_1.getWallet)(t.id,v.walletType,v.currency);null==a||a.step("Verifying wallet balance");if(I.balance<l){null==a||a.fail(`Insufficient balance: ${I.balance} < ${l}`);throw(0,error_1.createError)({statusCode:400,message:"Insufficient balance"})}null==a||a.step("Calculating ROI");const w=v.profitPercentage/100*l;null==a||a.step("Creating investment record and transaction");const _=await db_1.sequelize.transaction(async e=>{const n=`investment_${t.id}_${s}_${l}`;await wallet_1.walletService.debit({idempotencyKey:n,userId:t.id,walletId:I.id,walletType:v.walletType,currency:v.currency,amount:l,operationType:"AI_INVESTMENT",description:`Investment in ${v.name} plan for ${y.duration} ${y.timeframe}`,metadata:{planId:s,durationId:o,investmentType:i,roi:w},transaction:e});let r;try{r=await u.create({userId:t.id,planId:s,durationId:y.id,walletId:I.id,amount:l,profit:w,status:"ACTIVE",endDate:(0,date_1.getEndDate)(y.duration,y.timeframe)},{transaction:e})}catch(e){null==a||a.fail("Already invested in this plan");throw(0,error_1.createError)({statusCode:400,message:"Already invested in this plan"})}return r});null==a||a.step("Fetching investment details for email notification");const g=await u.findByPk(_.id,{include:[{model:db_1.models.user,as:"user",attributes:["id","firstName","lastName","email","avatar"]},{model:c,as:"plan"},{model:m,as:"duration"}]});if(!g){null==a||a.fail("Failed to fetch investment for email");throw(0,error_1.createError)({statusCode:500,message:"Failed to fetch the newly created investment for email."})}null==a||a.step("Sending investment confirmation email");await(0,emails_1.sendInvestmentEmail)(d,v,y,g,f,a);try{await(0,affiliate_1.processRewards)(t.id,l,"INVESTMENT",v.currency)}catch(e){console.error("Failed to process affiliate rewards:",e)}null==a||a.success(`${i} investment created: ${l} ${v.currency} for ${y.duration} ${y.timeframe}`);return{message:"Investment created successfully"}};