"use strict";async function processGeneralInvestments(){const e="processGeneralInvestments",t=Date.now();try{(0,broadcast_1.broadcastStatus)(e,"running");(0,broadcast_1.broadcastLog)(e,"Starting general investments processing");const a=await getActiveGeneralInvestments(),s=a.length;(0,broadcast_1.broadcastLog)(e,`Found ${s} active general investments`);for(let t=0;t<s;t++){const r=a[t];(0,broadcast_1.broadcastLog)(e,`Processing general investment id ${r.id}`);try{await processGeneralInvestment(r);(0,broadcast_1.broadcastLog)(e,`Processed investment id ${r.id}`,"success")}catch(t){console_1.logger.error("CRON",`Error processing investment ${r.id}`,t);(0,broadcast_1.broadcastLog)(e,`Error processing investment id ${r.id}: ${t.message}`,"error");continue}const n=Math.round((t+1)/s*100);(0,broadcast_1.broadcastProgress)(e,n)}(0,broadcast_1.broadcastStatus)(e,"completed",{duration:Date.now()-t});(0,broadcast_1.broadcastLog)(e,"General investments processing completed","success")}catch(t){console_1.logger.error("CRON","processGeneralInvestments failed",t);(0,broadcast_1.broadcastStatus)(e,"failed");(0,broadcast_1.broadcastLog)(e,`General investments processing failed: ${t.message}`,"error");throw t}}async function getActiveGeneralInvestments(){try{return await db_1.models.investment.findAll({where:{status:"ACTIVE"},include:[{model:db_1.models.investmentPlan,as:"plan",attributes:["id","name","title","description","defaultProfit","defaultResult","currency","walletType"]},{model:db_1.models.investmentDuration,as:"duration",attributes:["id","duration","timeframe"]}],order:[["status","ASC"],["createdAt","ASC"]]})}catch(e){console_1.logger.error("CRON","getActiveGeneralInvestments failed",e);throw e}}async function processGeneralInvestment(e){const t="processGeneralInvestments",{id:a,duration:s,createdAt:r,amount:n,profit:o,result:i,plan:d,userId:c}=e;if("COMPLETED"===e.status){(0,broadcast_1.broadcastLog)(t,`Investment ${a} is already COMPLETED; skipping`,"info");return null}if(!d){(0,broadcast_1.broadcastLog)(t,`Investment ${a} has no associated plan (plan may have been deleted); skipping`,"error");console_1.logger.error("CRON",`Investment ${a} has no associated plan`,new Error(`Investment ${a} has no associated plan`));return null}if(!s){(0,broadcast_1.broadcastLog)(t,`Investment ${a} has no associated duration (duration may have been deleted); skipping`,"error");console_1.logger.error("CRON",`Investment ${a} has no associated duration`,new Error(`Investment ${a} has no associated duration`));return null}(0,broadcast_1.broadcastLog)(t,`Fetching user for investment ${a}`);const l=await db_1.models.user.findByPk(c);if(!l){(0,broadcast_1.broadcastLog)(t,`User not found for investment ${a}`,"error");console_1.logger.error("CRON",`User not found for investment ${a}`,new Error("User not found"));return null}const m=o||d.defaultProfit;(0,broadcast_1.broadcastLog)(t,`Calculated ROI (${m}) for investment ${a}`);const u=i||d.defaultResult;(0,broadcast_1.broadcastLog)(t,`Determined result (${u}) for investment ${a}`);let b,g;switch(s.timeframe){case"HOUR":default:b=(0,date_fns_1.addHours)(new Date(r),s.duration);break;case"DAY":b=(0,date_fns_1.addDays)(new Date(r),s.duration);break;case"WEEK":b=(0,date_fns_1.addDays)(new Date(r),7*s.duration);break;case"MONTH":b=(0,date_fns_1.addDays)(new Date(r),30*s.duration)}(0,broadcast_1.broadcastLog)(t,`Calculated end date (${b.toISOString()}) for investment ${a}`);if(!(0,date_fns_1.isPast)(b)){(0,broadcast_1.broadcastLog)(t,`Investment ${a} is not ready for processing (end date not reached)`,"info");return null}(0,broadcast_1.broadcastLog)(t,`Investment ${a} is eligible for processing (end date passed)`);try{(0,broadcast_1.broadcastLog)(t,`Starting update for investment ${a}`);g=await db_1.sequelize.transaction(async e=>{(0,broadcast_1.broadcastLog)(t,`Fetching wallet for investment ${a}`);const s=await db_1.models.wallet.findOne({where:{userId:c,currency:d.currency,type:d.walletType},transaction:e});if(!s){(0,broadcast_1.broadcastLog)(t,`Wallet not found for user ${c} in investment ${a}`,"error");throw(0,error_1.createError)({statusCode:404,message:"Wallet not found"})}(0,broadcast_1.broadcastLog)(t,`Wallet found with balance ${s.balance} for investment ${a}`);const r="WIN"===u?m:0;if(r>0){const n=`investment_roi_${a}`;await wallet_1.walletService.credit({idempotencyKey:n,userId:c,walletId:s.id,walletType:d.walletType,currency:d.currency,amount:r,operationType:"AI_INVESTMENT_ROI",referenceId:a,description:`Investment ROI: ${d.name} - ${u}`,metadata:{investmentId:a,planId:d.id,result:u,roi:m},transaction:e});const o=s.balance+r;(0,broadcast_1.broadcastLog)(t,`Wallet updated for investment ${a}. New balance: ${o}`)}else(0,broadcast_1.broadcastLog)(t,`Investment ${a} result: ${u}, no payout`);await db_1.models.investment.update({status:"COMPLETED",result:u,profit:m},{where:{id:a},transaction:e});(0,broadcast_1.broadcastLog)(t,`Investment ${a} updated to COMPLETED with result ${u}`);return await db_1.models.investment.findByPk(a,{include:[{model:db_1.models.investmentPlan,as:"plan"},{model:db_1.models.investmentDuration,as:"duration"}],transaction:e})});(0,broadcast_1.broadcastLog)(t,`Transaction committed for investment ${a}`,"success")}catch(e){console_1.logger.error("CRON","processGeneralInvestment failed",e);(0,broadcast_1.broadcastLog)(t,`Error updating investment ${a}: ${e.message}`,"error");return null}if(g){try{(0,broadcast_1.broadcastLog)(t,`Sending investment email for investment ${a}`);await(0,emails_1.sendInvestmentEmail)(l,d,s,g,"InvestmentCompleted");(0,broadcast_1.broadcastLog)(t,`Investment email sent for investment ${a}`,"success");(0,broadcast_1.broadcastLog)(t,`Creating notification for investment ${a}`);await(0,notifications_1.createNotification)({userId:l.id,relatedId:g.id,title:"General Investment Completed",message:`Your general investment of ${n} ${d.currency} has been completed with a status of ${u}.`,type:"system",link:`/investments/${g.id}`,actions:[{label:"View Investment",link:`/investments/${g.id}`,primary:!0}]});(0,broadcast_1.broadcastLog)(t,`Notification created for investment ${a}`,"success")}catch(e){console_1.logger.error("CRON","Failed to send email/notification",e);(0,broadcast_1.broadcastLog)(t,`Error sending email/notification for investment ${a}: ${e.message}`,"error")}try{(0,broadcast_1.broadcastLog)(t,`Processing rewards for investment ${a}`);await(0,affiliate_1.processRewards)(l.id,n,"GENERAL_INVESTMENT",d.currency);(0,broadcast_1.broadcastLog)(t,`Rewards processed for investment ${a}`,"success")}catch(e){console_1.logger.error("CRON","Failed to process rewards",e);(0,broadcast_1.broadcastLog)(t,`Error processing rewards for investment ${a}: ${e.message}`,"error")}}return g}Object.defineProperty(exports,"__esModule",{value:!0});exports.processGeneralInvestments=processGeneralInvestments;exports.getActiveGeneralInvestments=getActiveGeneralInvestments;exports.processGeneralInvestment=processGeneralInvestment;const db_1=require("@b/db"),date_fns_1=require("date-fns"),console_1=require("@b/utils/console"),emails_1=require("@b/utils/emails"),notifications_1=require("@b/utils/notifications"),affiliate_1=require("@b/utils/affiliate"),broadcast_1=require("@b/cron/broadcast"),wallet_1=require("@b/services/wallet"),error_1=require("@b/utils/error");