"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const error_1=require("@b/utils/error"),schema_1=require("@b/utils/schema"),query_1=require("@b/utils/query"),utils_1=require("./currency/utils"),console_1=require("@b/utils/console");exports.metadata={summary:"Get exchange rate between two currencies",description:"Calculates the exchange rate between two currencies across different wallet types (FIAT, SPOT, ECO, FUTURES)",operationId:"getExchangeRate",tags:["Finance"],requiresAuth:!0,parameters:[{name:"fromCurrency",in:"query",description:"Source currency code (e.g., EUR, USD, BTC)",required:!0,schema:{type:"string"}},{name:"fromType",in:"query",description:"Source wallet type (FIAT, SPOT, ECO, FUTURES)",required:!0,schema:{type:"string",enum:["FIAT","SPOT","ECO","FUTURES"]}},{name:"toCurrency",in:"query",description:"Target currency code (e.g., EUR, USD, BTC)",required:!0,schema:{type:"string"}},{name:"toType",in:"query",description:"Target wallet type (FIAT, SPOT, ECO, FUTURES)",required:!0,schema:{type:"string",enum:["FIAT","SPOT","ECO","FUTURES"]}}],responses:{200:{description:"Exchange rate calculated successfully",content:{"application/json":{schema:{type:"object",properties:{rate:(0,schema_1.baseNumberSchema)("Exchange rate (1 fromCurrency = X toCurrency)"),fromPriceUSD:(0,schema_1.baseNumberSchema)("Price of source currency in USD"),toPriceUSD:(0,schema_1.baseNumberSchema)("Price of target currency in USD")}}}}},400:{description:"Invalid parameters or currencies"},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Currency"),500:query_1.serverErrorResponse}};exports.default=async e=>{const{user:r,query:t}=e;if(!(null==r?void 0:r.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});const{fromCurrency:a,fromType:s,toCurrency:o,toType:c}=t;if(!(a&&s&&o&&c))throw(0,error_1.createError)({statusCode:400,message:"Missing required parameters: fromCurrency, fromType, toCurrency, toType"});const i=["FIAT","SPOT","ECO","FUTURES"];if(!i.includes(s)||!i.includes(c))throw(0,error_1.createError)({statusCode:400,message:"Invalid wallet type. Must be FIAT, SPOT, ECO, or FUTURES"});try{let e,r;if("FIAT"===s)e=await(0,utils_1.getFiatPriceInUSD)(a);else if("SPOT"===s||"FUTURES"===s)e=await(0,utils_1.getSpotPriceInUSD)(a);else{if("ECO"!==s)throw(0,error_1.createError)({statusCode:400,message:`Unsupported wallet type: ${s}`});e=await(0,utils_1.getEcoPriceInUSD)(a)}if("FIAT"===c)r=await(0,utils_1.getFiatPriceInUSD)(o);else if("SPOT"===c||"FUTURES"===c)r=await(0,utils_1.getSpotPriceInUSD)(o);else{if("ECO"!==c)throw(0,error_1.createError)({statusCode:400,message:`Unsupported wallet type: ${c}`});r=await(0,utils_1.getEcoPriceInUSD)(o)}if(!e||isNaN(e)||e<=0)throw(0,error_1.createError)({statusCode:400,message:`Price not available for ${a} (${s})`});if(!r||isNaN(r)||r<=0)throw(0,error_1.createError)({statusCode:400,message:`Price not available for ${o} (${c})`});return{rate:e/r,fromPriceUSD:e,toPriceUSD:r}}catch(e){if(e.statusCode)throw e;console_1.logger.error("EXCHANGE","Error calculating exchange rate",e);throw(0,error_1.createError)({statusCode:500,message:e.message||"Failed to calculate exchange rate"})}};