"use strict";var __importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const exchange_1=__importDefault(require("@b/utils/exchange")),db_1=require("@b/db"),query_1=require("@b/utils/query"),error_1=require("@b/utils/error"),index_get_1=require("../../currency/[type]/[code]/[method]/index.get"),wallet_1=require("@b/services/wallet");exports.metadata={summary:"Initiates a spot deposit transaction",description:"This endpoint initiates a spot deposit transaction for the user",operationId:"initiateSpotDeposit",tags:["Finance","Deposit"],requiresAuth:!0,logModule:"SPOT_DEPOSIT",logTitle:"Initiate spot deposit",requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{currency:{type:"string"},chain:{type:"string"},trx:{type:"string"}},required:["currency","chain","trx"]}}}},responses:{200:{description:"Spot deposit transaction initiated successfully",content:{"application/json":{schema:{type:"object",properties:{message:{type:"string",description:"Success message"}}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Deposit Method"),500:query_1.serverErrorResponse}};exports.default=async e=>{const{user:t,body:r,ctx:n}=e;if(!(null==t?void 0:t.id)){null==n||n.fail("User not authenticated");throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"})}const{currency:i,chain:s,trx:a}=r;null==n||n.step("Processing network configuration");const o="xt"===await exchange_1.default.getProvider()?(0,index_get_1.handleNetworkMappingReverse)(s):s;null==n||n.step("Fetching user account");if(!await db_1.models.user.findByPk(t.id)){null==n||n.fail("User not found");throw(0,error_1.createError)({statusCode:404,message:"User not found"})}null==n||n.step("Checking for duplicate transaction");if(await db_1.models.transaction.findOne({where:{referenceId:a,type:"DEPOSIT"}})){null==n||n.warn("Transaction already exists");throw(0,error_1.createError)({statusCode:400,message:"Transaction already exists"})}null==n||n.step("Finding or creating SPOT wallet");const c=(await wallet_1.walletCreationService.getOrCreateWallet(t.id,"SPOT",i)).wallet;null==n||n.step("Validating currency");if(!await db_1.models.exchangeCurrency.findOne({where:{currency:i}})){null==n||n.fail("Currency not found");throw(0,error_1.createError)({statusCode:404,message:"Currency not found"})}null==n||n.step("Creating deposit transaction record");const u=await db_1.models.transaction.create({userId:t.id,walletId:c.id,type:"DEPOSIT",amount:0,status:"PENDING",description:`${i} deposit transaction initiated`,metadata:JSON.stringify({currency:i,chain:o,trx:a}),referenceId:a});null==n||n.success(`Spot deposit initiated: ${i} on ${o}`);return{transaction:u,currency:c.currency,chain:o,trx:a,method:"SPOT"}};