"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),utils_1=require("./utils");exports.metadata={summary:"Checks PayU payment status",description:"Queries current payment status with 1-hour expiration timeout and updates local records",operationId:"checkPayUPaymentStatus",tags:["Finance","Deposit","PayU"],requiresAuth:!0,parameters:[{name:"txnid",in:"query",required:!0,schema:{type:"string"},description:"PayU transaction ID"}],responses:{200:{description:"Payment status retrieved successfully",content:{"application/json":{schema:{type:"object",properties:{success:{type:"boolean"},data:{type:"object",properties:{transaction_id:{type:"string"},mihpayid:{type:"string"},status:{type:"string"},amount:{type:"number"},currency:{type:"string"},gateway:{type:"string"},payment_mode:{type:"string"},bank_name:{type:"string"},bank_ref_num:{type:"string"},card_type:{type:"string"},name_on_card:{type:"string"},payment_source:{type:"string"},error:{type:"string"},error_message:{type:"string"},is_expired:{type:"boolean"},expires_at:{type:"string"},callback_url:{type:"string"},last_updated:{type:"string"}}}}}}}},400:{description:"Bad request - Invalid transaction ID"},401:{description:"Unauthorized - User not authenticated"},404:{description:"Transaction not found"},500:{description:"Internal server error"}}};exports.default=async e=>{const{user:a,query:t}=e,{txnid:r}=t;if(!(null==a?void 0:a.id))throw(0,error_1.createError)({statusCode:401,message:"User not authenticated"});if(!r)throw(0,error_1.createError)({statusCode:400,message:"Transaction ID is required"});try{(0,utils_1.validatePayUConfig)();const e=await db_1.models.transaction.findOne({where:{uuid:r,userId:a.id,type:"DEPOSIT"}});if(!e)throw(0,error_1.createError)({statusCode:404,message:"Transaction not found"});const t=JSON.parse(e.metadata||"{}");if("payu"!==t.gateway)throw(0,error_1.createError)({statusCode:400,message:"Invalid gateway for this transaction"});const n=new Date(e.createdAt),s=new Date(n.getTime()+36e5),i=new Date>s;if(i&&"PENDING"===e.status){await e.update({status:"EXPIRED",metadata:JSON.stringify({...t,expiredAt:(new Date).toISOString(),lastStatusCheck:(new Date).toISOString()})});return{success:!0,data:{transaction_id:e.uuid,mihpayid:t.mihpayid||"",status:"EXPIRED",amount:e.amount,currency:t.currency||"INR",gateway:"payu",payment_mode:t.paymentMode||"",bank_name:t.bankName||"",bank_ref_num:t.bankRefNum||"",card_type:t.cardType||"",name_on_card:t.nameOnCard||"",payment_source:t.paymentSource||"",error:t.error||"",error_message:t.errorMessage||"",is_expired:!0,expires_at:s.toISOString(),callback_url:t.callbackUrl||"",last_updated:(new Date).toISOString()}}}if("PENDING"!==e.status)return{success:!0,data:{transaction_id:e.uuid,mihpayid:t.mihpayid||"",status:e.status,amount:e.amount,currency:t.currency||"INR",gateway:"payu",payment_mode:t.paymentMode||"",bank_name:t.bankName||"",bank_ref_num:t.bankRefNum||"",card_type:t.cardType||"",name_on_card:t.nameOnCard||"",payment_source:t.paymentSource||"",error:t.error||"",error_message:t.errorMessage||"",is_expired:i,expires_at:s.toISOString(),callback_url:t.callbackUrl||"",last_updated:e.updatedAt}};const o={key:utils_1.PAYU_CONFIG.MERCHANT_KEY,command:"verify_payment",var1:r,hash:""},u=`${utils_1.PAYU_CONFIG.MERCHANT_KEY}|verify_payment|${r}|${utils_1.PAYU_CONFIG.MERCHANT_SALT}`;o.hash=require("crypto").createHash("sha512").update(u).digest("hex");const c=await(0,utils_1.makePayURequest)("/merchant/postservice.php?form=2",{method:"POST",body:o,headers:{"Content-Type":"application/x-www-form-urlencoded"}});if(1!==c.status)return{success:!0,data:{transaction_id:e.uuid,mihpayid:t.mihpayid||"",status:e.status,amount:e.amount,currency:t.currency||"INR",gateway:"payu",payment_mode:t.paymentMode||"",bank_name:t.bankName||"",bank_ref_num:t.bankRefNum||"",card_type:t.cardType||"",name_on_card:t.nameOnCard||"",payment_source:t.paymentSource||"",error:t.error||"",error_message:t.errorMessage||"",is_expired:i,expires_at:s.toISOString(),callback_url:t.callbackUrl||"",last_updated:e.updatedAt}};const d=c.transaction_details[r];if(!d)return{success:!0,data:{transaction_id:e.uuid,mihpayid:t.mihpayid||"",status:e.status,amount:e.amount,currency:t.currency||"INR",gateway:"payu",payment_mode:t.paymentMode||"",bank_name:t.bankName||"",bank_ref_num:t.bankRefNum||"",card_type:t.cardType||"",name_on_card:t.nameOnCard||"",payment_source:t.paymentSource||"",error:t.error||"",error_message:t.errorMessage||"",is_expired:i,expires_at:s.toISOString(),callback_url:t.callbackUrl||"",last_updated:e.updatedAt}};const p=d.status,m=(0,utils_1.mapPayUStatus)(p);(0,utils_1.parsePayUAmount)(d.amt||"0",t.currency||"INR");m!==e.status&&await e.update({status:m,referenceId:d.mihpayid||e.referenceId,metadata:JSON.stringify({...t,mihpayid:d.mihpayid,bankRefNum:d.bank_ref_num,paymentMode:d.mode,bankCode:d.bankcode,bankName:d.bank_name,cardType:d.card_type,nameOnCard:d.name_on_card,cardNum:d.cardnum,paymentSource:d.payment_source,error:d.error,errorMessage:d.error_Message,payuStatusResponse:d,lastStatusCheck:(new Date).toISOString()})});return{success:!0,data:{transaction_id:e.uuid,mihpayid:d.mihpayid||"",status:m,amount:e.amount,currency:t.currency||"INR",gateway:"payu",payment_mode:d.mode||"",bank_name:d.bank_name||"",bank_ref_num:d.bank_ref_num||"",card_type:d.card_type||"",name_on_card:d.name_on_card||"",payment_source:d.payment_source||"",error:d.error||"",error_message:d.error_Message||"",is_expired:i,expires_at:s.toISOString(),callback_url:t.callbackUrl||"",last_updated:(new Date).toISOString()}}}catch(e){if(e.statusCode)throw e;throw(0,error_1.createError)({statusCode:500,message:e instanceof Error?e.message:"Status check failed"})}};