"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),utils_1=require("./utils");exports.metadata={summary:"Checks Paytm payment status",description:"Queries current payment status with 1-hour expiration timeout and updates local transaction records",operationId:"checkPaytmPaymentStatus",tags:["Finance","Deposit","Paytm"],requiresAuth:!0,parameters:[{name:"orderId",in:"query",required:!0,schema:{type:"string",description:"Paytm order ID"}}],responses:{200:{description:"Payment status retrieved successfully",content:{"application/json":{schema:{type:"object",properties:{success:{type:"boolean"},data:{type:"object",properties:{transaction_id:{type:"string"},order_id:{type:"string"},txn_id:{type:"string"},status:{type:"string"},amount:{type:"number"},currency:{type:"string"},gateway:{type:"string"},payment_mode:{type:"string"},bank_name:{type:"string"},gateway_name:{type:"string"},bank_txn_id:{type:"string"},txn_date:{type:"string"},is_expired:{type:"boolean"},expires_at:{type:"string"},callback_url:{type:"string"},last_updated:{type:"string"}}}}}}}},400:{description:"Bad request - Invalid parameters"},401:{description:"Unauthorized"},404:{description:"Transaction not found"},500:{description:"Internal server error"}}};exports.default=async t=>{const{user:e,query:a}=t,{orderId:r}=a;if(!(null==e?void 0:e.id))throw(0,error_1.createError)({statusCode:401,message:"User not authenticated"});if(!r)throw(0,error_1.createError)({statusCode:400,message:"Order ID is required"});try{(0,utils_1.validatePaytmConfig)();const t=await db_1.models.transaction.findOne({where:{uuid:r,userId:e.id,type:"DEPOSIT"}});if(!t)throw(0,error_1.createError)({statusCode:404,message:"Transaction not found"});const a=JSON.parse(t.metadata||"{}");if("paytm"!==a.gateway)throw(0,error_1.createError)({statusCode:400,message:"Invalid gateway for this transaction"});const n=new Date(t.createdAt),s=new Date(n.getTime()+36e5),o=new Date>s;if(o&&"PENDING"===t.status){await t.update({status:"EXPIRED",metadata:JSON.stringify({...a,expiredAt:(new Date).toISOString(),reason:"Payment timeout after 1 hour"})});return{success:!0,data:{transaction_id:t.uuid,order_id:r,txn_id:a.txnId||"",status:"EXPIRED",amount:t.amount,currency:a.currency||"INR",gateway:"paytm",payment_mode:a.paymentMode||"",bank_name:a.bankName||"",gateway_name:a.gatewayName||"",bank_txn_id:a.bankTxnId||"",txn_date:a.txnDate||"",is_expired:!0,expires_at:s.toISOString(),callback_url:a.callbackUrl||"",last_updated:(new Date).toISOString()}}}if("PENDING"!==t.status)return{success:!0,data:{transaction_id:t.uuid,order_id:r,txn_id:a.txnId||"",status:t.status,amount:t.amount,currency:a.currency||"INR",gateway:"paytm",payment_mode:a.paymentMode||"",bank_name:a.bankName||"",gateway_name:a.gatewayName||"",bank_txn_id:a.bankTxnId||"",txn_date:a.txnDate||"",is_expired:o,expires_at:s.toISOString(),callback_url:a.callbackUrl||"",last_updated:t.updatedAt}};const d={body:{mid:utils_1.PAYTM_CONFIG.MID,orderId:r}},i=(0,utils_1.generateChecksumHash)(d.body,utils_1.PAYTM_CONFIG.MERCHANT_KEY);d.body.checksumHash=i;const u=await(0,utils_1.makePaytmRequest)("/merchant-status/api/v1/getPaymentStatus",{method:"POST",body:d,headers:{"Content-Type":"application/json"}}),y=u.body.resultInfo.resultStatus,c=(0,utils_1.mapPaytmStatus)(y),m=(0,utils_1.parsePaytmAmount)(u.body.txnAmount||"0",a.currency||"INR");c!==t.status&&await t.update({status:c,referenceId:u.body.txnId||t.referenceId,metadata:JSON.stringify({...a,txnId:u.body.txnId,bankTxnId:u.body.bankTxnId,paymentMode:u.body.paymentMode,bankName:u.body.bankName,gatewayName:u.body.gatewayName,txnDate:u.body.txnDate,paytmStatusResponse:u.body,lastStatusCheck:(new Date).toISOString()})});return{success:!0,data:{transaction_id:t.uuid,order_id:r,txn_id:u.body.txnId||"",status:c,amount:m,currency:u.body.currency||a.currency||"INR",gateway:"paytm",payment_mode:u.body.paymentMode||"",bank_name:u.body.bankName||"",gateway_name:u.body.gatewayName||"",bank_txn_id:u.body.bankTxnId||"",txn_date:u.body.txnDate||"",is_expired:o,expires_at:s.toISOString(),callback_url:a.callbackUrl||"",last_updated:(new Date).toISOString()}}}catch(t){if(t instanceof utils_1.PaytmError)throw(0,error_1.createError)({statusCode:t.status,message:t.message});throw(0,error_1.createError)({statusCode:500,message:"Failed to check Paytm payment status"})}};