"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),utils_1=require("./utils");exports.metadata={summary:"Creates a Paytm payment session",description:"Initializes a payment with Paytm and returns transaction token for comprehensive payment methods including UPI, cards, net banking, wallets, and EMI across India and international markets",operationId:"createPaytmPayment",tags:["Finance","Deposit","Paytm"],requiresAuth:!0,logModule:"PAYTM_DEPOSIT",logTitle:"Create Paytm payment session",requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{amount:{type:"number",description:"Payment amount",minimum:1},currency:{type:"string",description:"Payment currency code",enum:["INR","USD","EUR","GBP","AUD","CAD","SGD","AED","JPY","CNY","CHF","QAR"],example:"INR"},paymentModes:{type:"array",items:{type:"string"},description:"Preferred payment modes",example:["upi","card","netbanking"]},metadata:{type:"object",description:"Additional metadata for the transaction",additionalProperties:!0}},required:["amount","currency"]}}}},responses:{200:{description:"Paytm payment session created successfully",content:{"application/json":{schema:{type:"object",properties:{success:{type:"boolean"},data:{type:"object",properties:{transaction_id:{type:"string"},order_id:{type:"string"},txn_token:{type:"string"},status:{type:"string"},gateway:{type:"string"},amount:{type:"number"},currency:{type:"string"},region:{type:"string"},available_methods:{type:"object",additionalProperties:{type:"string"}},supported_channels:{type:"array",items:{type:"string"}},fees_info:{type:"object",properties:{fees:{type:"number"},net_amount:{type:"number"},gross_amount:{type:"number"}}},callback_url:{type:"string"}}}}}}}},400:{description:"Bad request - Invalid parameters",content:{"application/json":{schema:{type:"object",properties:{error:{type:"string"},details:{type:"object"}}}}}},401:{description:"Unauthorized"},404:{description:"Payment gateway not found"},500:{description:"Internal server error"}}};exports.default=async e=>{const{user:t,body:r}=e,{amount:a,currency:s,paymentModes:n,metadata:o={}}=r;if(!(null==t?void 0:t.id))throw(0,error_1.createError)({statusCode:401,message:"User not authenticated"});if(!a||a<=0)throw(0,error_1.createError)({statusCode:400,message:"Invalid amount provided"});if(!s)throw(0,error_1.createError)({statusCode:400,message:"Currency is required"});const i=s.toUpperCase();try{(0,utils_1.validatePaytmConfig)();if(!(0,utils_1.isCurrencySupported)(i))throw(0,error_1.createError)({statusCode:400,message:`Currency ${i} is not supported by Paytm. Supported currencies: INR, USD, EUR, GBP, AUD, CAD, SGD, AED, JPY, CNY, CHF, QAR`});const e=await db_1.models.depositGateway.findOne({where:{alias:"paytm"}});if(!e||!e.status)throw(0,error_1.createError)({statusCode:400,message:"Paytm payment gateway is not available"});if(!JSON.parse(e.currencies||"[]").includes(i))throw(0,error_1.createError)({statusCode:400,message:`Currency ${i} is not supported by this gateway`});const r=JSON.parse(e.minAmount||"{}"),s=JSON.parse(e.maxAmount||"{}"),u=r[i]||1,d=s[i]||1e7;if(a<u)throw(0,error_1.createError)({statusCode:400,message:`Minimum amount is ${u} ${i}`});if(a>d)throw(0,error_1.createError)({statusCode:400,message:`Maximum amount is ${d} ${i}`});const c=(0,utils_1.generatePaytmOrderId)(),p=(0,utils_1.formatPaytmAmount)(a,i),m=(0,utils_1.getCurrencyInfo)(i),y=(0,utils_1.getAvailablePaymentMethods)(i),l=(0,utils_1.getSupportedChannels)(i),_=(0,utils_1.calculatePaytmFees)(a,i),g=await db_1.models.transaction.create({uuid:c,userId:t.id,type:"DEPOSIT",status:"PENDING",amount:a,fee:_.fees,description:`Paytm deposit of ${a} ${i}`,metadata:JSON.stringify({gateway:"paytm",currency:i,orderId:c,region:(null==m?void 0:m.region)||"Unknown",availableMethods:y,...o})}),b={body:{requestType:"Payment",mid:utils_1.PAYTM_CONFIG.MID,websiteName:utils_1.PAYTM_CONFIG.WEBSITE,orderId:c,txnAmount:{value:p,currency:i},userInfo:{custId:t.id.toString(),email:t.email||"",mobile:t.phone||""},callbackUrl:(0,utils_1.buildCallbackUrl)(),enablePaymentMode:n&&n.length>0?n:y}},P=(0,utils_1.generateChecksumHash)(b.body,utils_1.PAYTM_CONFIG.MERCHANT_KEY);b.body.checksumHash=P;const h=await(0,utils_1.makePaytmRequest)("/theia/api/v1/initiateTransaction",{method:"POST",body:b,headers:{"Content-Type":"application/json"}});await g.update({referenceId:h.body.txnToken,metadata:JSON.stringify({...JSON.parse(g.metadata||"{}"),txnToken:h.body.txnToken,paytmResponse:h.body})});const C=y.reduce((e,t)=>{e[t]=(0,utils_1.getPaymentMethodDisplayName)(t);return e},{});return{success:!0,data:{transaction_id:g.uuid,order_id:c,txn_token:h.body.txnToken,status:"PENDING",gateway:"paytm",amount:a,currency:i,region:(null==m?void 0:m.region)||"Unknown",available_methods:C,supported_channels:l,fees_info:_,callback_url:(0,utils_1.buildCallbackUrl)(),paytm_config:{mid:utils_1.PAYTM_CONFIG.MID,website:utils_1.PAYTM_CONFIG.WEBSITE,industry_type:utils_1.PAYTM_CONFIG.INDUSTRY_TYPE,is_sandbox:utils_1.PAYTM_CONFIG.SANDBOX}}}}catch(e){if(e instanceof utils_1.PaytmError)throw(0,error_1.createError)({statusCode:e.status,message:e.message});throw(0,error_1.createError)({statusCode:500,message:"Failed to create Paytm payment session"})}};