"use strict";function getStatusMessage(e){switch(e){case"COMPLETED":return"Payment completed successfully";case"PENDING":return"Payment is being processed";case"FAILED":return"Payment failed";case"CANCELLED":return"Payment was cancelled";case"EXPIRED":return"Payment session expired";case"REFUNDED":return"Payment has been refunded";case"CHARGEBACK":return"Payment has been charged back";default:return"Payment status unknown"}}Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),wallet_1=require("@b/services/wallet"),error_1=require("@b/utils/error"),emails_1=require("@b/utils/emails"),console_1=require("@b/utils/console"),utils_1=require("./utils");exports.metadata={summary:"Verifies a Paysafe payment",description:"Handles return URL verification after payment completion and updates transaction status",operationId:"verifyPaysafePayment",tags:["Finance","Deposit","Paysafe"],requiresAuth:!0,logModule:"PAYSAFE_DEPOSIT",logTitle:"Verify Paysafe payment",requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{payment_handle_token:{type:"string",description:"Payment handle token from Paysafe"},payment_id:{type:"string",description:"Payment ID from Paysafe (optional)"},reference:{type:"string",description:"Transaction reference"},status:{type:"string",description:"Payment status from return URL"}},required:["payment_handle_token","reference"]}}}},responses:{200:{description:"Payment verification completed",content:{"application/json":{schema:{type:"object",properties:{success:{type:"boolean"},data:{type:"object",properties:{transaction_id:{type:"string"},status:{type:"string"},amount:{type:"number"},currency:{type:"string"},gateway_transaction_id:{type:"string"},message:{type:"string"}}}}}}}},400:{description:"Bad request - Invalid parameters"},401:{description:"Unauthorized"},404:{description:"Transaction not found"},500:{description:"Internal server error"}}};exports.default=async e=>{var t;const{user:a,body:r}=e,{payment_handle_token:s,payment_id:n,reference:i,status:o}=r;if(!(null==a?void 0:a.id))throw(0,error_1.createError)({statusCode:401,message:"User not authenticated"});if(!s||!i)throw(0,error_1.createError)({statusCode:400,message:"Payment handle token and reference are required"});try{(0,utils_1.validatePaysafeConfig)();const e=await db_1.models.transaction.findOne({where:{uuid:i,userId:a.id,status:"PENDING"}});if(!e)throw(0,error_1.createError)({statusCode:404,message:"Transaction not found or already processed"});let r;if(n)r=await(0,utils_1.makeApiRequest)(`payments/${n}`,{method:"GET"});else try{r=await(0,utils_1.makeApiRequest)(`payments?merchantRefNum=${i}`,{method:"GET"});Array.isArray(r)&&(r=r[0])}catch(a){console_1.logger.warn("PAYSAFE",`Payment not found, might still be processing: ${a.message}`);return{success:!0,data:{transaction_id:e.id,status:"PENDING",amount:e.amount,currency:(null===(t=e.metadata)||void 0===t?void 0:t.currency)||"USD",message:"Payment is still being processed"}}}if(!r)throw(0,error_1.createError)({statusCode:404,message:"Payment details not found in Paysafe"});if(r.merchantRefNum!==i)throw(0,error_1.createError)({statusCode:400,message:"Payment reference mismatch"});const s=(0,utils_1.mapPaysafeStatus)(r.status),o=(0,utils_1.parsePaysafeAmount)(r.amount,r.currencyCode),c=await db_1.sequelize.transaction(async t=>{var n;await e.update({status:s,metadata:{...e.metadata,paymentId:r.id,gatewayTransactionId:r.gatewayReconciliationId,gatewayStatus:r.status,processedAt:(new Date).toISOString(),gatewayResponse:r.gatewayResponse,settlements:r.settlements}},{transaction:t});if("COMPLETED"===s){const s=(await wallet_1.walletCreationService.getOrCreateWallet(a.id,"FIAT",r.currencyCode,t)).wallet,n=`paysafe_verify_${e.id}`;await wallet_1.walletService.credit({idempotencyKey:n,userId:a.id,walletId:s.id,walletType:"FIAT",currency:r.currencyCode,amount:o,operationType:"DEPOSIT",referenceId:e.id,description:`Paysafe deposit of ${o} ${r.currencyCode}`,metadata:{method:"PAYSAFE",paymentId:r.id,gatewayTransactionId:r.gatewayReconciliationId},transaction:t});const i=await db_1.models.depositGateway.findOne({where:{id:"paysafe"}});if(i){const s=i.getPercentageFee(e.currency),n=i.getFixedFee(e.currency),c=o*s/100+n;c>0&&await db_1.models.adminProfit.create({amount:c,currency:r.currencyCode,type:"DEPOSIT",transactionId:e.id,description:`Admin profit from Paysafe deposit fee of ${c} ${r.currencyCode} for user (${a.id})`},{transaction:t})}try{const t=await db_1.models.wallet.findOne({where:{userId:a.id,currency:r.currencyCode}});await(0,emails_1.sendFiatTransactionEmail)(a,e,r.currencyCode,(null==t?void 0:t.balance)||o)}catch(e){console_1.logger.error("PAYSAFE","Failed to send confirmation email",e)}}return{transaction_id:e.id,status:s,amount:o,currency:r.currencyCode,gateway_transaction_id:r.id,gateway_reconciliation_id:r.gatewayReconciliationId,processor:null===(n=r.gatewayResponse)||void 0===n?void 0:n.processor,message:getStatusMessage(s)}});return{success:!0,data:c}}catch(e){console_1.logger.error("PAYSAFE","Payment verification error",e);if(e instanceof utils_1.PaysafeError)throw(0,error_1.createError)({statusCode:e.status,message:`Paysafe Error: ${e.message}`});throw(0,error_1.createError)({statusCode:500,message:e.message||"Failed to verify Paysafe payment"})}};