"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),console_1=require("@b/utils/console"),utils_1=require("./utils");exports.metadata={summary:"Creates a Paysafe payment session",description:"Initiates a payment with Paysafe using Payment Handles API and returns checkout URL for various payment methods",operationId:"createPaysafePayment",tags:["Finance","Deposit","Paysafe"],requiresAuth:!0,logModule:"PAYSAFE_DEPOSIT",logTitle:"Create Paysafe payment session",requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{amount:{type:"number",description:"Payment amount",minimum:.01},currency:{type:"string",description:"Payment currency code",example:"USD"},paymentType:{type:"string",description:"Preferred payment method type",enum:["CARD","PAYPAL","VENMO","SKRILL","NETELLER","APPLEPAY","GOOGLEPAY","ACH","EFT","PAYSAFECARD","PAYSAFECASH"],default:"CARD"},locale:{type:"string",description:"User locale for payment page",example:"en_US"}},required:["amount","currency"]}}}},responses:{200:{description:"Paysafe payment session created successfully",content:{"application/json":{schema:{type:"object",properties:{success:{type:"boolean"},data:{type:"object",properties:{transaction_id:{type:"string"},payment_handle_id:{type:"string"},payment_handle_token:{type:"string"},checkout_url:{type:"string"},reference:{type:"string"},status:{type:"string"},gateway:{type:"string"},amount:{type:"number"},currency:{type:"string"},payment_type:{type:"string"},expires_at:{type:"string"},available_methods:{type:"object",additionalProperties:{type:"string"}}}}}}}}},400:{description:"Bad request - Invalid parameters",content:{"application/json":{schema:{type:"object",properties:{error:{type:"string"},details:{type:"object"}}}}}},401:{description:"Unauthorized"},404:{description:"Payment gateway not found"},500:{description:"Internal server error"}}};exports.default=async e=>{var t,r,a,s,o,n;const{user:i,body:d}=e,{amount:u,currency:c,paymentType:p="CARD",locale:l="en_US"}=d;if(!(null==i?void 0:i.id))throw(0,error_1.createError)({statusCode:401,message:"User not authenticated"});if(!u||u<=0)throw(0,error_1.createError)({statusCode:400,message:"Invalid amount provided"});if(!c)throw(0,error_1.createError)({statusCode:400,message:"Currency is required"});const y=c.toUpperCase();try{(0,utils_1.validatePaysafeConfig)();if(!(0,utils_1.isCurrencySupported)(y))throw(0,error_1.createError)({statusCode:400,message:`Currency ${y} is not supported by Paysafe`});const d=await db_1.models.depositGateway.findOne({where:{id:"paysafe"}});if(!d||!d.status)throw(0,error_1.createError)({statusCode:400,message:"Paysafe payment gateway is not available"});if(!JSON.parse(d.currencies||"[]").includes(y))throw(0,error_1.createError)({statusCode:400,message:`Currency ${y} is not supported`});const m=d.getMinAmount(c),f=d.getMaxAmount(c);if(u<m)throw(0,error_1.createError)({statusCode:400,message:`Minimum amount is ${m} ${y}`});if(null!==f&&u>f)throw(0,error_1.createError)({statusCode:400,message:`Maximum amount is ${f} ${y}`});const g=(0,utils_1.generatePaysafeReference)(),_=await db_1.models.transaction.create({uuid:g,userId:i.id,type:"DEPOSIT",status:"PENDING",amount:u,fee:0,description:`Paysafe deposit - ${u} ${y}`,metadata:JSON.stringify({gateway:"paysafe",currency:y,originalAmount:u,paymentType:p,locale:l})}),h=await db_1.models.user.findByPk(i.id,{attributes:["firstName","lastName","email","phone"]}),P={merchantRefNum:g,transactionType:"PAYMENT",amount:(0,utils_1.formatPaysafeAmount)(u,y),currencyCode:y,paymentType:p,customerIp:e.remoteAddress||"127.0.0.1",billingDetails:{street:(null==h?void 0:h.firstName)||"N/A",city:"N/A",zip:"00000",country:(0,utils_1.getRegionFromCurrency)(y)},customer:{merchantCustomerId:i.id,firstName:(null==h?void 0:h.firstName)||"Customer",lastName:(null==h?void 0:h.lastName)||"User",email:(null==h?void 0:h.email)||`user${i.id}@example.com`,phone:(null==h?void 0:h.phone)||"+1234567890",ip:e.remoteAddress||"127.0.0.1"},merchantDescriptor:{dynamicDescriptor:"Paysafe Payment",phone:"+1234567890"},returnLinks:[{rel:"on_completed",href:(0,utils_1.buildReturnUrl)(),method:"GET"},{rel:"on_failed",href:(0,utils_1.buildCancelUrl)(),method:"GET"},{rel:"default",href:(0,utils_1.buildReturnUrl)(),method:"GET"}],webhookUrl:(0,utils_1.buildWebhookUrl)()},w=await(0,utils_1.makeApiRequest)("paymenthandles",{method:"POST",body:P});await _.update({metadata:{..._.metadata,paymentHandleId:w.id,paymentHandleToken:w.paymentHandleToken,gatewayId:null===(t=w.gatewayResponse)||void 0===t?void 0:t.id,processorId:null===(r=w.gatewayResponse)||void 0===r?void 0:r.processor}});const A=null===(a=w.links)||void 0===a?void 0:a.find(e=>"redirect_payment"===e.rel||"checkout"===e.rel);if(!A)throw(0,error_1.createError)({statusCode:500,message:"No checkout URL received from Paysafe"});const b=(0,utils_1.getAvailablePaymentMethods)(y).reduce((e,t)=>{e[t]=(0,utils_1.getPaymentMethodDisplayName)(t);return e},{}),v=new Date(Date.now()+1e3*w.timeToLiveSeconds).toISOString();return{success:!0,data:{transaction_id:_.id,payment_handle_id:w.id,payment_handle_token:w.paymentHandleToken,checkout_url:A.href,reference:g,status:"PENDING",gateway:"paysafe",amount:u,currency:y,payment_type:p,expires_at:v,available_methods:b,processor:(null===(s=w.gatewayResponse)||void 0===s?void 0:s.processor)||"PAYSAFE",gateway_response:{id:null===(o=w.gatewayResponse)||void 0===o?void 0:o.id,processor:null===(n=w.gatewayResponse)||void 0===n?void 0:n.processor,action:w.action,execution_mode:w.executionMode,usage:w.usage}}}}catch(e){console_1.logger.error("PAYSAFE","Payment creation error",e);if(e instanceof utils_1.PaysafeError)throw(0,error_1.createError)({statusCode:e.status,message:`Paysafe Error: ${e.message}`});throw(0,error_1.createError)({statusCode:500,message:e.message||"Failed to create Paysafe payment"})}};