"use strict";function validateMollieConfig(){if(!exports.MOLLIE_CONFIG.API_KEY)throw(0,error_1.createError)({statusCode:500,message:"Mollie API key is not configured"})}function isCurrencySupported(e){return Object.keys(exports.MOLLIE_CURRENCY_METHODS).includes(e.toUpperCase())}function getAvailablePaymentMethods(e){const a=e.toUpperCase();return exports.MOLLIE_CURRENCY_METHODS[a]||[]}function formatMollieAmount(e,a){const o=exports.MOLLIE_CURRENCY_DECIMALS[a.toUpperCase()]||2;return(e/Math.pow(10,o)).toFixed(o)}function parseMollieAmount(e,a){const o=exports.MOLLIE_CURRENCY_DECIMALS[a.toUpperCase()]||2;return Math.round(parseFloat(e)*Math.pow(10,o))}function getMollieLocale(e){const a=e.split("-")[0].toLowerCase();return exports.MOLLIE_LOCALE_MAP[a]||"en_US"}function mapMollieStatus(e){return exports.MOLLIE_STATUS_MAPPING[e]||"PENDING"}function generateMollieReference(){return`MOLLIE_${Date.now()}_${Math.random().toString(36).substring(2,8)}`.toUpperCase()}async function makeApiRequest(e,a={}){validateMollieConfig();const o=`${exports.MOLLIE_CONFIG.API_BASE_URL}${e}`,{method:t="GET",body:r,headers:p={}}=a,l={Authorization:`Bearer ${exports.MOLLIE_CONFIG.API_KEY}`,"Content-Type":"application/json","User-Agent":"v5-platform/1.0.0",...p};try{const e=await fetch(o,{method:t,headers:l,body:r?JSON.stringify(r):void 0,signal:AbortSignal.timeout(exports.MOLLIE_CONFIG.TIMEOUT)}),a=await e.json();if(!e.ok){const o=a;throw new MollieError(o.detail||o.title||"Mollie API request failed",o.status||e.status,o.type,o.field)}return a}catch(e){if(e instanceof MollieError)throw e;if("TimeoutError"===e.name)throw new MollieError("Mollie API request timed out",408);if("TypeError"===e.name&&e.message.includes("fetch"))throw new MollieError("Network error connecting to Mollie API",503);throw new MollieError(e.message||"Unknown error occurred with Mollie API",500)}}function buildWebhookUrl(){return`${process.env.APP_PUBLIC_URL||"https://localhost:3000"}${exports.MOLLIE_CONFIG.WEBHOOK_ENDPOINT}`}function buildReturnUrl(){return`${process.env.APP_PUBLIC_URL||"https://localhost:3000"}${exports.MOLLIE_CONFIG.RETURN_URL}`}function isTestMode(){return exports.MOLLIE_CONFIG.API_KEY.startsWith("test_")}function validateWebhookSignature(){return!0}function getPaymentMethodDisplayName(e){return{creditcard:"Credit Card",ideal:"iDEAL",bancontact:"Bancontact",sofort:"SOFORT Banking",paypal:"PayPal",applepay:"Apple Pay",googlepay:"Google Pay",sepadirectdebit:"SEPA Direct Debit",banktransfer:"Bank Transfer",klarna:"Klarna",przelewy24:"Przelewy24",eps:"EPS",giropay:"Giropay",kbc:"KBC Payment Button",belfius:"Belfius Pay Button"}[e]||e}Object.defineProperty(exports,"__esModule",{value:!0});exports.MollieError=exports.MOLLIE_STATUS_MAPPING=exports.MOLLIE_LOCALE_MAP=exports.MOLLIE_CURRENCY_DECIMALS=exports.MOLLIE_CURRENCY_METHODS=exports.MOLLIE_CONFIG=void 0;exports.validateMollieConfig=validateMollieConfig;exports.isCurrencySupported=isCurrencySupported;exports.getAvailablePaymentMethods=getAvailablePaymentMethods;exports.formatMollieAmount=formatMollieAmount;exports.parseMollieAmount=parseMollieAmount;exports.getMollieLocale=getMollieLocale;exports.mapMollieStatus=mapMollieStatus;exports.generateMollieReference=generateMollieReference;exports.makeApiRequest=makeApiRequest;exports.buildWebhookUrl=buildWebhookUrl;exports.buildReturnUrl=buildReturnUrl;exports.isTestMode=isTestMode;exports.validateWebhookSignature=validateWebhookSignature;exports.getPaymentMethodDisplayName=getPaymentMethodDisplayName;const error_1=require("@b/utils/error");exports.MOLLIE_CONFIG={API_BASE_URL:"https://api.mollie.com/v2",API_KEY:process.env.APP_MOLLIE_API_KEY||"",WEBHOOK_ENDPOINT:process.env.APP_MOLLIE_WEBHOOK_ENDPOINT||"/api/finance/deposit/fiat/mollie/webhook",RETURN_URL:process.env.APP_MOLLIE_RETURN_URL||"/user/wallet/deposit/mollie/verify",TIMEOUT:3e4};exports.MOLLIE_CURRENCY_METHODS={EUR:["creditcard","ideal","bancontact","sofort","paypal","applepay","googlepay","sepadirectdebit","banktransfer","klarna","przelewy24","eps","giropay","kbc","belfius"],USD:["creditcard","paypal","applepay","googlepay"],GBP:["creditcard","paypal","applepay","googlepay"],CHF:["creditcard","paypal","applepay","googlepay"],SEK:["creditcard","paypal","klarna","applepay","googlepay"],NOK:["creditcard","paypal","klarna","applepay","googlepay"],DKK:["creditcard","paypal","klarna","applepay","googlepay"],PLN:["creditcard","paypal","przelewy24","applepay","googlepay"],CZK:["creditcard","paypal","applepay","googlepay"],AUD:["creditcard","paypal","applepay","googlepay"],CAD:["creditcard","paypal","applepay","googlepay"],JPY:["creditcard","paypal","applepay","googlepay"],HKD:["creditcard","paypal","applepay","googlepay"],SGD:["creditcard","paypal","applepay","googlepay"],NZD:["creditcard","paypal","applepay","googlepay"],ZAR:["creditcard","applepay","googlepay"],BGN:["creditcard","applepay","googlepay"],RON:["creditcard","applepay","googlepay"],HUF:["creditcard","paypal","applepay","googlepay"],ISK:["creditcard","applepay","googlepay"],ILS:["creditcard","paypal","applepay","googlepay"],MYR:["paypal"],PHP:["creditcard","paypal","applepay","googlepay"],THB:["paypal"],TWD:["paypal"]};exports.MOLLIE_CURRENCY_DECIMALS={EUR:2,USD:2,GBP:2,CHF:2,SEK:2,NOK:2,DKK:2,PLN:2,CZK:2,AUD:2,CAD:2,HKD:2,SGD:2,NZD:2,ZAR:2,BGN:2,RON:2,HUF:2,ILS:2,MYR:2,PHP:2,THB:2,TWD:2,JPY:0,ISK:0};exports.MOLLIE_LOCALE_MAP={en:"en_US",nl:"nl_NL",de:"de_DE",fr:"fr_FR",es:"es_ES",it:"it_IT",pt:"pt_PT",pl:"pl_PL",cs:"cs_CZ",da:"da_DK",sv:"sv_SE",no:"nb_NO",fi:"fi_FI",hu:"hu_HU",bg:"bg_BG",ro:"ro_RO",sk:"sk_SK",sl:"sl_SI",hr:"hr_HR",et:"et_EE",lv:"lv_LV",lt:"lt_LT",mt:"mt_MT"};exports.MOLLIE_STATUS_MAPPING={open:"PENDING",pending:"PENDING",authorized:"PENDING",paid:"COMPLETED",canceled:"CANCELLED",expired:"EXPIRED",failed:"FAILED",refunded:"REFUNDED",charged_back:"CHARGEBACK"};class MollieError extends Error{constructor(e,a=500,o,t){super(e);this.name="MollieError";this.status=a;this.type=o;this.field=t}}exports.MollieError=MollieError;