"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const error_1=require("@b/utils/error"),db_1=require("@b/db"),console_1=require("@b/utils/console"),utils_1=require("./utils");exports.metadata={summary:"Creates a Mollie payment session",description:"Initiates a payment with Mollie and returns checkout URL",operationId:"createMolliePayment",tags:["Finance","Deposit","Mollie"],requiresAuth:!0,logModule:"MOLLIE_DEPOSIT",logTitle:"Create Mollie payment session",requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{amount:{type:"number",description:"Payment amount",minimum:.01},currency:{type:"string",description:"Payment currency code",example:"EUR"},method:{type:"string",description:"Preferred payment method (optional)",example:"creditcard"},locale:{type:"string",description:"User locale for payment page",example:"en"}},required:["amount","currency"]}}}},responses:{200:{description:"Payment session created successfully",content:{"application/json":{schema:{type:"object",properties:{success:{type:"boolean"},data:{type:"object",properties:{transactionId:{type:"string"},paymentId:{type:"string"},checkoutUrl:{type:"string"},amount:{type:"number"},currency:{type:"string"},status:{type:"string"},expiresAt:{type:"string"},availableMethods:{type:"array",items:{type:"string"}}}}}}}}},400:{description:"Bad request - invalid parameters"},401:{description:"Unauthorized"},500:{description:"Internal server error"}}};exports.default=async e=>{var t,r;const{body:o,user:a,ctx:s}=e;if(!(null==a?void 0:a.id))throw(0,error_1.createError)({statusCode:401,message:"Authentication required"});if(!o.amount||!o.currency)throw(0,error_1.createError)({statusCode:400,message:"Amount and currency are required"});(0,utils_1.validateMollieConfig)();if(!(0,utils_1.isCurrencySupported)(o.currency))throw(0,error_1.createError)({statusCode:400,message:`Currency ${o.currency} is not supported by Mollie`});if(o.amount<=0)throw(0,error_1.createError)({statusCode:400,message:"Amount must be greater than 0"});const{amount:i,currency:n,method:u,locale:c="en"}=o;try{null==s||s.step("Fetching payment gateway configuration");const e=await db_1.models.depositGateway.findOne({where:{id:"mollie"}});if(!e||!e.status)throw(0,error_1.createError)({statusCode:400,message:"Mollie payment gateway is not available"});if(!JSON.parse(e.currencies||"[]").includes(n.toUpperCase()))throw(0,error_1.createError)({statusCode:400,message:`Currency ${n} is not supported`});const o=e.getMinAmount(n),l=e.getMaxAmount(n);if(i<o)throw(0,error_1.createError)({statusCode:400,message:`Minimum amount is ${o} ${n}`});if(null!==l&&i>l)throw(0,error_1.createError)({statusCode:400,message:`Maximum amount is ${l} ${n}`});const d=(0,utils_1.generateMollieReference)();null==s||s.step("Creating transaction record");const m=await db_1.models.transaction.create({uuid:d,userId:a.id,type:"DEPOSIT",status:"PENDING",amount:i,fee:0,description:`Mollie deposit - ${i} ${n}`,metadata:JSON.stringify({gateway:"mollie",currency:n,method:u||"auto",locale:c})}),p=(0,utils_1.getAvailablePaymentMethods)(n);if(u&&!p.includes(u))throw(0,error_1.createError)({statusCode:400,message:`Payment method ${u} is not available for ${n}`});const y=(0,utils_1.formatMollieAmount)(100*i,n),h=(0,utils_1.getMollieLocale)(c),g={amount:{currency:n.toUpperCase(),value:y},description:`Deposit ${i} ${n.toUpperCase()}`,redirectUrl:`${(0,utils_1.buildReturnUrl)()}?transaction=${m.uuid}`,webhookUrl:(0,utils_1.buildWebhookUrl)(),metadata:{transactionId:m.uuid,userId:a.id,platform:"v5",type:"deposit"},locale:h};u&&(g.method=u);a.firstName&&a.lastName&&(g.consumerName=`${a.firstName} ${a.lastName}`);const _=await(0,utils_1.makeApiRequest)("/payments",{method:"POST",body:g});if(!_.id||!(null===(r=null===(t=_._links)||void 0===t?void 0:t.checkout)||void 0===r?void 0:r.href))throw(0,error_1.createError)({statusCode:500,message:"Failed to create Mollie payment session"});await db_1.models.transaction.update({referenceId:_.id,metadata:JSON.stringify({...m.metadata,molliePaymentId:_.id,mollieStatus:_.status,expiresAt:_.expiresAt,checkoutUrl:_._links.checkout.href})},{where:{uuid:m.uuid}});return{success:!0,data:{transactionId:m.uuid,paymentId:_.id,checkoutUrl:_._links.checkout.href,amount:i,currency:n.toUpperCase(),status:_.status,expiresAt:_.expiresAt,availableMethods:p}}}catch(e){console_1.logger.error("MOLLIE","Payment creation error",e);if(e.statusCode)throw e;throw(0,error_1.createError)({statusCode:500,message:e.message||"Failed to create Mollie payment"})}};