"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const query_1=require("@b/utils/query"),utils_1=require("./utils"),db_1=require("@b/db"),console_1=require("@b/utils/console"),wallet_1=require("@b/services/wallet");exports.metadata={summary:"Handles iPay88 webhook notifications",description:"Processes iPay88 backend notifications for payment events. This endpoint handles automatic payment status updates, wallet balance updates, and transaction processing based on iPay88's notification system.",operationId:"handleIpay88Webhook",tags:["Finance","Webhook"],logModule:"WEBHOOK",logTitle:"iPay88 webhook",requestBody:{description:"iPay88 webhook notification data",content:{"application/json":{schema:{type:"object",properties:{MerchantCode:{type:"string",description:"iPay88 merchant code"},PaymentId:{type:"string",description:"Payment ID"},RefNo:{type:"string",description:"Reference number"},Amount:{type:"string",description:"Payment amount in cents"},Currency:{type:"string",description:"Currency code"},Remark:{type:"string",description:"Payment remark"},TransId:{type:"string",description:"iPay88 transaction ID"},AuthCode:{type:"string",description:"Authorization code"},Status:{type:"string",description:"Payment status"},ErrDesc:{type:"string",description:"Error description"},Signature:{type:"string",description:"iPay88 signature for verification"},CCName:{type:"string",description:"Credit card holder name",nullable:!0},CCNo:{type:"string",description:"Masked credit card number",nullable:!0},S_bankname:{type:"string",description:"Bank name",nullable:!0},S_country:{type:"string",description:"Country code",nullable:!0}},required:["MerchantCode","PaymentId","RefNo","Amount","Currency","TransId","Status","Signature"]}}}},responses:{200:{description:"Webhook processed successfully",content:{"text/plain":{schema:{type:"string",example:"RECEIVEOK"}}}},400:{description:"Bad request - Invalid signature or parameters",content:{"text/plain":{schema:{type:"string",example:"FAIL"}}}},404:(0,query_1.notFoundMetadataResponse)("Transaction not found"),500:query_1.serverErrorResponse}};exports.default=async e=>{const{body:t,ctx:a}=e;try{const{MerchantCode:e,PaymentId:a,RefNo:n,Amount:r,Currency:o,Remark:s,TransId:i,AuthCode:c,Status:d,ErrDesc:u,Signature:p,CCName:l,CCNo:y,S_bankname:m,S_country:_}=t;console_1.logger.info("IPAY88",`Webhook received - ref: ${n}, status: ${d}, amount: ${r} ${o}`);if(!(e&&n&&r&&o&&d&&p)){console_1.logger.error("IPAY88","Missing required webhook parameters");return new Response("FAIL",{status:400})}const g=(0,utils_1.getIpay88Config)();if(e!==g.merchantCode){console_1.logger.error("IPAY88",`Invalid merchant code in webhook: ${e}`);return new Response("FAIL",{status:400})}const I=await db_1.models.transaction.findOne({where:{metadata:{ipay88_reference:n}}});if(!I){console_1.logger.error("IPAY88",`Transaction not found for reference: ${n}`);return new Response("FAIL",{status:404})}if(!(0,utils_1.verifyIpay88Signature)(g.merchantKey,e,a,n,r,o,d,p)){console_1.logger.error("IPAY88",`Webhook signature verification failed for reference: ${n}`);await I.update({status:"FAILED",metadata:{...I.metadata,webhook_verification_failed:!0,signature_valid:!1,ipay88_webhook_response:t}});return new Response("FAIL",{status:400})}const b=(0,utils_1.convertFromIpay88Amount)(r);if(Math.abs(b-I.amount)>.01){console_1.logger.error("IPAY88",`Amount mismatch: expected ${I.amount}, received ${b}`);return new Response("FAIL",{status:400})}const h=utils_1.IPAY88_STATUS_MAPPING[d]||"FAILED";if("COMPLETED"===I.status&&"COMPLETED"===h){console_1.logger.debug("IPAY88",`Transaction ${n} already completed, skipping`);return new Response("RECEIVEOK",{status:200})}const w={status:h,metadata:{...I.metadata,ipay88_transaction_id:i,ipay88_auth_code:c,ipay88_status:d,ipay88_error_desc:u,ipay88_remark:s,signature_valid:!0,ipay88_webhook_response:t,webhook_processed_at:(new Date).toISOString()}};l||y?w.metadata.payment_method_details={type:"credit_card",card_holder:l,masked_number:y}:m&&(w.metadata.payment_method_details={type:"online_banking",bank_name:m,country:_});if("COMPLETED"===h){const e=I.metadata.currency;await db_1.sequelize.transaction(async t=>{let a=await db_1.models.wallet.findOne({where:{userId:I.userId,currency:e,type:"FIAT"},transaction:t});a||(a=await wallet_1.walletCreationService.getOrCreateWallet(I.userId,"FIAT",e,t));const r=`ipay88_webhook_${n}`;await wallet_1.walletService.credit({idempotencyKey:r,userId:I.userId,walletId:a.id,walletType:"FIAT",currency:e,amount:I.amount,operationType:"DEPOSIT",referenceId:n,description:`iPay88 deposit - ${I.amount} ${e}`,metadata:{method:"IPAY88",transId:i,authCode:c},transaction:t});w.metadata.wallet_updated=!0;w.metadata.wallet_updated_at=(new Date).toISOString();await I.update(w,{transaction:t})});console_1.logger.success("IPAY88",`Wallet updated for user ${I.userId}: +${I.amount} ${e}`)}else await I.update(w);console_1.logger.success("IPAY88",`Webhook processed for ${n}: status=${h}, amount=${b} ${o}`);return new Response("RECEIVEOK",{status:200})}catch(e){console_1.logger.error("IPAY88","Webhook processing error",e);return new Response("FAIL",{status:500})}};