"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const query_1=require("@b/utils/query"),error_1=require("@b/utils/error"),console_1=require("@b/utils/console"),utils_1=require("./utils"),db_1=require("@b/db"),wallet_1=require("@b/services/wallet");exports.metadata={summary:"Verifies iPay88 payment status",description:"Handles iPay88 payment verification from return URL. This endpoint processes the payment response from iPay88 and updates the transaction status accordingly.",operationId:"verifyIpay88Payment",tags:["Finance","Payment"],logModule:"IPAY88_DEPOSIT",logTitle:"Verify iPay88 payment",requestBody:{description:"iPay88 payment response data",content:{"application/json":{schema:{type:"object",properties:{MerchantCode:{type:"string",description:"iPay88 merchant code"},PaymentId:{type:"string",description:"Payment ID"},RefNo:{type:"string",description:"Reference number"},Amount:{type:"string",description:"Payment amount in cents"},Currency:{type:"string",description:"Currency code"},Remark:{type:"string",description:"Payment remark"},TransId:{type:"string",description:"iPay88 transaction ID"},AuthCode:{type:"string",description:"Authorization code"},Status:{type:"string",description:"Payment status"},ErrDesc:{type:"string",description:"Error description"},Signature:{type:"string",description:"iPay88 signature for verification"},CCName:{type:"string",description:"Credit card holder name",nullable:!0},CCNo:{type:"string",description:"Masked credit card number",nullable:!0},S_bankname:{type:"string",description:"Bank name",nullable:!0},S_country:{type:"string",description:"Country code",nullable:!0}},required:["MerchantCode","PaymentId","RefNo","Amount","Currency","TransId","Status","Signature"]}}}},responses:{200:{description:"Payment verification completed",content:{"application/json":{schema:{type:"object",properties:{success:{type:"boolean"},data:{type:"object",properties:{transaction_id:{type:"string"},reference:{type:"string"},status:{type:"string"},amount:{type:"number"},currency:{type:"string"},gateway:{type:"string"},ipay88_transaction_id:{type:"string"},auth_code:{type:"string"},payment_method:{type:"string"},signature_valid:{type:"boolean"}}}}}}}},400:{description:"Bad request - Invalid signature or parameters",content:{"application/json":{schema:{type:"object",properties:{error:{type:"string"},details:{type:"object"}}}}}},404:(0,query_1.notFoundMetadataResponse)("Transaction not found"),500:query_1.serverErrorResponse}};exports.default=async e=>{var t;const{body:r,ctx:a}=e;try{const{MerchantCode:e,PaymentId:a,RefNo:n,Amount:i,Currency:s,Remark:o,TransId:d,AuthCode:c,Status:p,ErrDesc:y,Signature:u,CCName:m,CCNo:l,S_bankname:_,S_country:g}=r;if(!(e&&n&&i&&s&&p&&u))throw(0,error_1.createError)({statusCode:400,message:"Missing required iPay88 response parameters"});const f=(0,utils_1.getIpay88Config)();if(e!==f.merchantCode)throw(0,error_1.createError)({statusCode:400,message:"Invalid merchant code"});const h=await db_1.models.transaction.findOne({where:{metadata:{ipay88_reference:n}}});if(!h)throw(0,error_1.createError)({statusCode:404,message:`Transaction not found for reference: ${n}`});if(!(0,utils_1.verifyIpay88Signature)(f.merchantKey,e,a,n,i,s,p,u)){console_1.logger.error("IPAY88","Signature verification failed",{reference:n,expected_signature:u,received_data:{MerchantCode:e,PaymentId:a,RefNo:n,Amount:i,Currency:s,Status:p}});await h.update({status:"FAILED",metadata:JSON.stringify({...h.metadata,verification_failed:!0,signature_valid:!1,ipay88_response:r})});throw(0,error_1.createError)({statusCode:400,message:"Invalid signature - payment verification failed"})}const I=(0,utils_1.convertFromIpay88Amount)(i);if(Math.abs(I-h.amount)>.01)throw(0,error_1.createError)({statusCode:400,message:`Amount mismatch: expected ${h.amount}, received ${I}`});const P=utils_1.IPAY88_STATUS_MAPPING[p]||"FAILED",C={status:P,metadata:{...h.metadata,ipay88_transaction_id:d,ipay88_auth_code:c,ipay88_status:p,ipay88_error_desc:y,ipay88_remark:o,signature_valid:!0,ipay88_response:r}};m||l?C.metadata.payment_method_details={type:"credit_card",card_holder:m,masked_number:l}:_&&(C.metadata.payment_method_details={type:"online_banking",bank_name:_,country:g});if("COMPLETED"===P){const e=(await wallet_1.walletCreationService.getOrCreateWallet(h.userId,"FIAT",h.metadata.currency)).wallet,t=`ipay88_verify_${h.id}`;await wallet_1.walletService.credit({idempotencyKey:t,userId:h.userId,walletId:e.id,walletType:"FIAT",currency:h.metadata.currency,amount:h.amount,operationType:"DEPOSIT",referenceId:n,description:`iPay88 deposit of ${h.amount} ${h.metadata.currency}`,metadata:{method:"IPAY88",transactionId:d,authCode:c}});C.metadata.wallet_updated=!0}await h.update(C);const b=utils_1.IPAY88_RESPONSE_CODES[c]||y||"Unknown response";return{success:!0,data:{transaction_id:h.id,reference:n,status:P,amount:I,currency:s,gateway:"ipay88",ipay88_transaction_id:d,auth_code:c,response_message:b,payment_method:(null===(t=C.metadata.payment_method_details)||void 0===t?void 0:t.type)||"unknown",signature_valid:!0,timestamp:(new Date).toISOString()}}}catch(e){console_1.logger.error("IPAY88","Payment verification error",e);if(e instanceof utils_1.Ipay88Error)throw(0,error_1.createError)({statusCode:400,message:`iPay88 Error: ${e.message}`});throw(0,error_1.createError)({statusCode:500,message:e.message||"Failed to verify iPay88 payment"})}};