"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),query_1=require("@b/utils/query"),error_1=require("@b/utils/error"),wallet_1=require("@b/services/wallet");exports.metadata={summary:"Performs a custom fiat deposit transaction",description:"Initiates a custom fiat deposit transaction for the currently authenticated user",operationId:"createCustomFiatDeposit",tags:["Wallets"],requiresAuth:!0,logModule:"FIAT_DEPOSIT",logTitle:"Create custom fiat deposit",requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{methodId:{type:"string",description:"Deposit method ID"},amount:{type:"number",description:"Amount to deposit"},currency:{type:"string",description:"Currency to deposit"},customFields:{type:"object",description:"Custom data for the deposit"}},required:["methodId","amount","currency","customFields"]}}}},responses:{200:{description:"Custom deposit transaction initiated successfully",content:{"application/json":{schema:{type:"object",properties:{transaction:{type:"object"},currency:{type:"string"},method:{type:"string"}}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Deposit Method"),500:query_1.serverErrorResponse}};exports.default=async e=>{const{user:t,body:r,ctx:o}=e;if(!(null==t?void 0:t.id)){null==o||o.fail("User not authenticated");throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"})}const{methodId:s,amount:i,currency:a,customFields:n}=r;null==o||o.step("Fetching user account");if(!await db_1.models.user.findByPk(t.id)){null==o||o.fail("User not found");throw(0,error_1.createError)({statusCode:404,message:"User not found"})}null==o||o.step("Validating deposit method");const d=await db_1.models.depositMethod.findByPk(s);if(!d){null==o||o.fail("Deposit method not found");throw(0,error_1.createError)({statusCode:404,message:"Deposit method not found"})}null==o||o.step("Validating currency");if(!await db_1.models.currency.findOne({where:{id:a}})){null==o||o.fail("Currency not found");throw(0,error_1.createError)({statusCode:404,message:"Currency not found"})}null==o||o.step("Calculating deposit fees");const c=parseFloat(i),u=d.fixedFee||0,l=d.percentageFee||0,p=parseFloat(Math.max(c*l/100+u,0).toFixed(2));null==o||o.step("Processing deposit transaction");const m=await db_1.sequelize.transaction(async e=>{const r=(await wallet_1.walletCreationService.getOrCreateWallet(t.id,"FIAT",a,e)).wallet,o=await db_1.models.transaction.create({userId:t.id,walletId:r.id,type:"DEPOSIT",amount:c,fee:p,status:"PENDING",metadata:JSON.stringify({method:d.title,...n}),description:`Deposit ${c} ${r.currency} by ${d.title}`},{transaction:e});p>0&&await db_1.models.adminProfit.create({amount:p,currency:r.currency,type:"DEPOSIT",transactionId:o.id,description:`Admin profit from deposit fee of ${p} ${r.currency} by ${d.title} for user (${t.id})`},{transaction:e});return o});null==o||o.success(`Fiat deposit created: ${c} ${a} via ${d.title}`);return{transaction:m,currency:a,method:d.title}};