"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const query_1=require("@b/utils/query"),error_1=require("@b/utils/error"),utils_1=require("./utils"),db_1=require("@b/db"),console_1=require("@b/utils/console"),publicUrl=process.env.NEXT_PUBLIC_SITE_URL,isProduction="production"===process.env.NODE_ENV;exports.metadata={summary:"Creates a dLocal payment",description:"Initiates a dLocal payment process for emerging markets. Supports multiple payment methods including cards, bank transfers, cash payments, and digital wallets across 60+ countries.",operationId:"createDLocalPayment",tags:["Finance","Deposit"],logModule:"DLOCAL_DEPOSIT",logTitle:"Create dLocal payment",requestBody:{description:"Payment information including customer details and document ID for compliance",content:{"application/json":{schema:{type:"object",properties:{amount:{type:"number",description:"Payment amount in the specified currency"},currency:{type:"string",description:"Currency code (e.g., USD, BRL, ARS)"},country:{type:"string",description:"Two-letter country code (e.g., BR, AR, MX)"},payment_method_id:{type:"string",description:"Payment method ID (e.g., CARD, VI, MC, or specific local methods)",default:"CARD"},customer:{type:"object",properties:{name:{type:"string",description:"Customer full name"},email:{type:"string",description:"Customer email address"},document_id:{type:"string",description:"Customer document ID (required for most countries)"},phone:{type:"string",description:"Customer phone number with country code"},address:{type:"object",properties:{street:{type:"string"},city:{type:"string"},state:{type:"string"},zip_code:{type:"string"}}}},required:["name","email"]},description:{type:"string",description:"Payment description"}},required:["amount","currency","country","customer"]}}}},responses:{200:{description:"dLocal payment created successfully. Returns payment details and redirect URL for completion.",content:{"application/json":{schema:{type:"object",properties:{id:{type:"string",description:"dLocal payment ID"},order_id:{type:"string",description:"Internal order reference"},status:{type:"string",description:"Payment status"},amount:{type:"number",description:"Payment amount"},currency:{type:"string",description:"Payment currency"},payment_method_type:{type:"string",description:"Type of payment method used"},redirect_url:{type:"string",description:"URL to redirect customer for payment completion",nullable:!0},payment_url:{type:"string",description:"Direct payment URL",nullable:!0},created_date:{type:"string",description:"Payment creation timestamp"}}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("dLocal"),500:query_1.serverErrorResponse},requiresAuth:!0};exports.default=async e=>{var t;const{user:r,body:o,ctx:a}=e;if(!r)throw(0,error_1.createError)({statusCode:401,message:"User not authenticated"});const{amount:s,currency:n,country:i,payment_method_id:d="CARD",customer:c,description:u="Deposit"}=o;if(!(0,utils_1.validateCurrency)(n))throw(0,error_1.createError)({statusCode:400,message:`Currency ${n} is not supported by dLocal`});null==a||a.step("Fetching payment gateway configuration");const p=await db_1.models.depositGateway.findOne({where:{alias:"dlocal",status:!0}});if(!p){null==a||a.fail("Payment gateway not found");throw(0,error_1.createError)({statusCode:404,message:"dLocal gateway not found or disabled"})}if(!(null===(t=p.currencies)||void 0===t?void 0:t.includes(n)))throw(0,error_1.createError)({statusCode:400,message:`Currency ${n} is not supported by dLocal gateway configuration`});const m=utils_1.COUNTRY_DOCUMENT_REQUIREMENTS[null==i?void 0:i.toUpperCase()];if((null==m?void 0:m.required)&&!c.document_id)throw(0,error_1.createError)({statusCode:400,message:`Document ID is required for ${i}. Required: ${m.name} (${m.format})`});const{fixedFee:l,percentageFee:y}=p,_=s*(y||0)/100+(l||0),g=s+_,f=`DL-${Date.now()}-${r.id}`;try{null==a||a.step("Creating transaction record");const e=await db_1.models.transaction.create({uuid:f,userId:r.id,type:"DEPOSIT",status:"PENDING",amount:s,fee:_,description:u,metadata:JSON.stringify({gateway:"dlocal",currency:n,country:i,payment_method_id:d,customer:c})}),t={amount:g,currency:n.toUpperCase(),country:i.toUpperCase(),payment_method_id:d,order_id:f,payer:{name:c.name,email:c.email,document:c.document_id,phone:c.phone,address:c.address?{country:i.toUpperCase(),state:c.address.state,city:c.address.city,zip_code:c.address.zip_code,street:c.address.street}:void 0},description:u,notification_url:`${publicUrl}${isProduction?"":":3000"}/api/finance/deposit/fiat/dlocal/webhook`,callback_url:`${publicUrl}${isProduction?"":":3000"}/finance/deposit?gateway=dlocal&status=success`},o=await(0,utils_1.makeDLocalRequest)("/payments","POST",t);await e.update({referenceId:o.id,metadata:JSON.stringify({...e.metadata,dlocal_payment_id:o.id,dlocal_status:o.status,dlocal_status_code:o.status_code,payment_method_type:o.payment_method_type,payment_method_flow:o.payment_method_flow})});console_1.logger.info("DLOCAL",`Payment created: ${o.id} for user ${r.id}`);return{id:o.id,order_id:f,status:o.status,amount:o.amount,currency:o.currency,payment_method_type:o.payment_method_type,redirect_url:o.redirect_url,payment_url:o.payment_url,created_date:o.created_date}}catch(e){console_1.logger.error("DLOCAL","Payment creation error",e);if(f)try{await db_1.models.transaction.update({status:"FAILED",metadata:JSON.stringify({error:e.message,timestamp:(new Date).toISOString()})},{where:{uuid:f}})}catch(e){console_1.logger.error("DLOCAL","Failed to update transaction status",e)}if(e instanceof utils_1.DLocalError)throw(0,error_1.createError)({statusCode:400,message:`dLocal API Error: ${e.message}`});throw(0,error_1.createError)({statusCode:500,message:`Payment creation failed: ${e.message}`})}};