"use strict";async function handleAuthorizationCreated(e){const{id:t,merchantReferenceId:o,authAmount:n,responseCode:r}=e;if(!o){console_1.logger.info("AUTH_NET","No merchant reference ID found in authorization webhook");return}const a=await db_1.models.transaction.findOne({where:{referenceId:o}});if(a){await db_1.models.transaction.update({status:1===r?"PENDING":"FAILED",description:`${a.description} - Authorization ${1===r?"approved":"declined"}`,metadata:JSON.stringify({...JSON.parse(a.metadata||"{}"),authorizationId:t,authAmount:n,responseCode:r})},{where:{id:a.id}});console_1.logger.info("AUTH_NET",`Authorization ${1===r?"approved":"declined"} for transaction ${o}`)}else console_1.logger.info("AUTH_NET",`Transaction not found for reference ID: ${o}`)}async function handleCaptureCreated(e){const{id:t,merchantReferenceId:o,authAmount:n,responseCode:r}=e;if(!o){console_1.logger.info("AUTH_NET","No merchant reference ID found in capture webhook");return}const a=await db_1.models.transaction.findOne({where:{referenceId:o},include:[{model:db_1.models.user,as:"user"}]});if(!a){console_1.logger.info("AUTH_NET",`Transaction not found for reference ID: ${o}`);return}if("COMPLETED"===a.status){console_1.logger.info("AUTH_NET",`Transaction ${o} already completed`);return}const i=JSON.parse(a.metadata||"{}"),s=i.currency,d=(await wallet_1.walletCreationService.getOrCreateWallet(a.userId,"FIAT",s)).wallet,c=await db_1.models.currency.findOne({where:{id:d.currency}});if(!c){console_1.logger.error("AUTH_NET",`Currency ${s} not found`);return}const u=a.amount,l=a.fee||0;let f=Number(d.balance);f+=u;f=Number(f.toFixed(c.precision||2));await db_1.sequelize.transaction(async e=>{await db_1.models.transaction.update({status:"COMPLETED",description:`${a.description} - Payment captured`,metadata:JSON.stringify({...i,captureId:t,captureAmount:n,captureResponseCode:r})},{where:{id:a.id},transaction:e});const c=`authorizenet_capture_${o}`;await wallet_1.walletService.credit({idempotencyKey:c,userId:a.userId,walletId:d.id,walletType:"FIAT",currency:s,amount:u,operationType:"DEPOSIT",referenceId:o,description:`Authorize.Net deposit - ${u} ${s}`,metadata:{method:"AUTHORIZE_NET",captureId:t,captureAmount:n},transaction:e});if(l>0)try{await db_1.models.adminProfit.create({amount:l,currency:d.currency,type:"DEPOSIT",description:`Authorize.Net deposit fee for transaction ${o}`,transactionId:a.id},{transaction:e})}catch(e){console_1.logger.error("AUTH_NET","Failed to record admin profit",e)}});try{const e=a.user||await db_1.models.user.findByPk(a.userId);e&&await(0,emails_1.sendFiatTransactionEmail)(e,{...a.toJSON(),status:"COMPLETED"},s,f)}catch(e){console_1.logger.error("AUTH_NET","Failed to send transaction email",e)}console_1.logger.success("AUTH_NET",`Payment captured for transaction ${o}, amount: ${u} ${s}`)}async function handleRefundCreated(e){const{id:t,merchantReferenceId:o,authAmount:n}=e;if(!o){console_1.logger.info("AUTH_NET","No merchant reference ID found in refund webhook");return}const r=await db_1.models.transaction.findOne({where:{referenceId:o}});if(r){await db_1.models.transaction.update({status:"REFUNDED",description:`${r.description} - Refunded`,metadata:JSON.stringify({...JSON.parse(r.metadata||"{}"),refundId:t,refundAmount:n})},{where:{id:r.id}});console_1.logger.info("AUTH_NET",`Refund processed for transaction ${o}, amount: ${n}`)}else console_1.logger.info("AUTH_NET",`Transaction not found for reference ID: ${o}`)}async function handleVoidCreated(e){const{id:t,merchantReferenceId:o}=e;if(!o){console_1.logger.info("AUTH_NET","No merchant reference ID found in void webhook");return}const n=await db_1.models.transaction.findOne({where:{referenceId:o}});if(n){await db_1.models.transaction.update({status:"CANCELLED",description:`${n.description} - Voided`,metadata:JSON.stringify({...JSON.parse(n.metadata||"{}"),voidId:t})},{where:{id:n.id}});console_1.logger.info("AUTH_NET",`Transaction voided: ${o}`)}else console_1.logger.info("AUTH_NET",`Transaction not found for reference ID: ${o}`)}async function handleFraudApproved(e){const{merchantReferenceId:t}=e;if(!t){console_1.logger.info("AUTH_NET","No merchant reference ID found in fraud approved webhook");return}const o=await db_1.models.transaction.findOne({where:{referenceId:t}});if(o){await db_1.models.transaction.update({metadata:JSON.stringify({...JSON.parse(o.metadata||"{}"),fraudStatus:"approved"})},{where:{id:o.id}});console_1.logger.info("AUTH_NET",`Fraud check approved for transaction ${t}`)}else console_1.logger.info("AUTH_NET",`Transaction not found for reference ID: ${t}`)}async function handleFraudDeclined(e){const{merchantReferenceId:t}=e;if(!t){console_1.logger.info("AUTH_NET","No merchant reference ID found in fraud declined webhook");return}const o=await db_1.models.transaction.findOne({where:{referenceId:t}});if(o){await db_1.models.transaction.update({status:"FAILED",description:`${o.description} - Declined by fraud detection`,metadata:JSON.stringify({...JSON.parse(o.metadata||"{}"),fraudStatus:"declined"})},{where:{id:o.id}});console_1.logger.warn("AUTH_NET",`Transaction declined by fraud detection: ${t}`)}else console_1.logger.info("AUTH_NET",`Transaction not found for reference ID: ${t}`)}Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const query_1=require("@b/utils/query"),error_1=require("@b/utils/error"),db_1=require("@b/db"),emails_1=require("@b/utils/emails"),utils_1=require("./utils"),console_1=require("@b/utils/console"),wallet_1=require("@b/services/wallet");exports.metadata={summary:"Handle Authorize.Net webhook notifications",description:"Processes Authorize.Net webhook notifications for payment events including authorizations, captures, refunds, and cancellations.",operationId:"handleAuthorizeNetWebhook",tags:["Finance","Webhook"],logModule:"WEBHOOK",logTitle:"AuthorizeNet webhook",requiresAuth:!1,requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{notificationId:{type:"string",description:"Unique notification ID"},eventType:{type:"string",description:"Type of event (net.authorize.payment.authorization.created, etc.)"},eventDate:{type:"string",description:"Event timestamp"},webhookId:{type:"string",description:"Webhook configuration ID"},payload:{type:"object",description:"Event payload with transaction details"}},required:["notificationId","eventType","eventDate","webhookId","payload"]}}}},responses:{200:{description:"Webhook processed successfully",content:{"application/json":{schema:{type:"object",properties:{status:{type:"string",example:"success"},message:{type:"string",example:"Webhook processed successfully"}}}}}},400:{description:"Invalid webhook payload or signature",content:{"application/json":{schema:{type:"object",properties:{error:{type:"string",example:"Invalid webhook signature"}}}}}},500:query_1.serverErrorResponse}};exports.default=async e=>{const{body:t,headers:o,ctx:n}=e;try{const e=(0,utils_1.getAuthorizeNetConfig)(),n=o["x-anet-signature"],r=JSON.stringify(t);if(e.signatureKey&&n){if(!(0,utils_1.verifyWebhookSignature)(r,n,e.signatureKey)){console_1.logger.error("AUTH_NET","Invalid webhook signature");return{status:400,body:{error:"Invalid webhook signature"}}}}const a=t,{eventType:i,payload:s}=a;console_1.logger.info("AUTH_NET",`Processing webhook: ${i} | notificationId: ${a.notificationId}, id: ${s.id}`);switch(i){case"net.authorize.payment.authorization.created":await handleAuthorizationCreated(s);break;case"net.authorize.payment.capture.created":await handleCaptureCreated(s);break;case"net.authorize.payment.refund.created":await handleRefundCreated(s);break;case"net.authorize.payment.void.created":await handleVoidCreated(s);break;case"net.authorize.payment.fraud.approved":await handleFraudApproved(s);break;case"net.authorize.payment.fraud.declined":await handleFraudDeclined(s);break;default:console_1.logger.info("AUTH_NET",`Unhandled webhook event type: ${i}`)}return{status:"success",message:"Webhook processed successfully"}}catch(e){console_1.logger.error("AUTH_NET","Webhook processing error",e);throw(0,error_1.createError)({statusCode:500,message:e instanceof Error?e.message:"Failed to process webhook"})}};