"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const query_1=require("@b/utils/query"),error_1=require("@b/utils/error"),console_1=require("@b/utils/console"),utils_1=require("./utils"),db_1=require("@b/db"),sequelize_1=require("sequelize"),utils_2=require("@b/api/finance/utils");exports.metadata={summary:"Verifies an Adyen payment",description:"Manually verifies an Adyen payment by checking the payment status and updating the transaction accordingly. This endpoint is used for manual verification when automatic webhook processing is not available.",operationId:"verifyAdyenPayment",tags:["Finance","Deposit"],logModule:"ADYEN_DEPOSIT",logTitle:"Verify Adyen payment",requestBody:{description:"Payment verification data",content:{"application/json":{schema:{type:"object",properties:{reference:{type:"string",description:"Transaction reference"},pspReference:{type:"string",description:"Adyen PSP reference",nullable:!0}},required:["reference"]}}}},responses:{200:{description:"Payment verification completed successfully",content:{"application/json":{schema:{type:"object",properties:{success:{type:"boolean",description:"Whether the verification was successful"},status:{type:"string",description:"Payment status"},message:{type:"string",description:"Verification message"},transaction:{type:"object",description:"Updated transaction details"}}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Transaction"),500:query_1.serverErrorResponse},requiresAuth:!0};exports.default=async e=>{var t;const{user:r,body:s,ctx:a}=e;if(!r)throw(0,error_1.createError)({statusCode:401,message:"User not authenticated"});const{reference:n,pspReference:i}=s;try{const e=await db_1.models.transaction.findOne({where:{uuid:n,userId:r.id,type:"DEPOSIT",status:{[sequelize_1.Op.in]:["PENDING","PROCESSING"]}}});if(!e)throw(0,error_1.createError)({statusCode:404,message:"Transaction not found or already processed"});const s=(0,utils_1.getAdyenConfig)();let a;if(i)try{const e={pspReference:i};a=await(0,utils_1.makeAdyenApiRequest)("/payments/details",e,s)}catch(e){throw(0,error_1.createError)({statusCode:400,message:`Failed to fetch payment details: ${e.message}`})}else{const t=e.metadata;if(!(null==t?void 0:t.pspReference))throw(0,error_1.createError)({statusCode:400,message:"PSP reference not provided and not found in transaction metadata"});{const e={pspReference:t.pspReference};a=await(0,utils_1.makeAdyenApiRequest)("/payments/details",e,s)}}const o=a.resultCode;let c,d=!1;switch(o){case"Authorised":c="COMPLETED";d=!0;break;case"Cancelled":case"Error":case"Refused":default:c="FAILED";break;case"Pending":case"Received":c="PROCESSING"}const u=await db_1.models.transaction.update({status:c,metadata:JSON.stringify({...e.metadata,pspReference:a.pspReference,resultCode:o,verifiedAt:(new Date).toISOString(),verificationMethod:"manual"})},{where:{id:e.id},returning:!0});if(d){const s=(null===(t=e.metadata)||void 0===t?void 0:t.currency)||"USD";await(0,utils_2.processFiatDeposit)({userId:r.id,currency:s,amount:e.amount,fee:e.fee||0,referenceId:a.pspReference,method:"ADYEN",description:`Adyen deposit - ${e.amount} ${s}`,metadata:{pspReference:a.pspReference,resultCode:o},idempotencyKey:`adyen_deposit_${a.pspReference}`})}return{success:d,status:c,message:d?"Payment verified and wallet updated successfully":`Payment verification completed with status: ${o}`,transaction:u[1][0],pspReference:a.pspReference,resultCode:o}}catch(e){console_1.logger.error("ADYEN","Payment verification error",e);throw(0,error_1.createError)({statusCode:500,message:`Payment verification failed: ${e.message}`})}};