"use strict";var __importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0});exports.makeAdyenApiRequest=exports.verifyHmacSignature=exports.convertFromMinorUnits=exports.convertToMinorUnits=exports.getAdyenHeaders=exports.getAdyenApiUrl=exports.getAdyenConfig=void 0;const crypto_1=__importDefault(require("crypto")),console_1=require("@b/utils/console"),error_1=require("@b/utils/error"),getAdyenConfig=()=>{const e=process.env.APP_ADYEN_API_KEY,t=process.env.APP_ADYEN_MERCHANT_ACCOUNT,r=process.env.APP_ADYEN_ENVIRONMENT||"test",o=process.env.APP_ADYEN_HMAC_KEY;if(!e)throw(0,error_1.createError)({statusCode:500,message:"Adyen API key is not set in environment variables"});if(!t)throw(0,error_1.createError)({statusCode:500,message:"Adyen merchant account is not set in environment variables"});return{apiKey:e,merchantAccount:t,environment:r,hmacKey:o}};exports.getAdyenConfig=getAdyenConfig;const getAdyenApiUrl=e=>"live"===e?"https://checkout-live.adyen.com/v71":"https://checkout-test.adyen.com/v71";exports.getAdyenApiUrl=getAdyenApiUrl;const getAdyenHeaders=e=>({"Content-Type":"application/json","X-API-Key":e});exports.getAdyenHeaders=getAdyenHeaders;const convertToMinorUnits=(e,t)=>["JPY","KRW","VND","CLP","PYG","UGX","RWF","VUV","XAF","XOF","XPF","BIF","CLP","DJF","GNF","ISK","KMF","IDR","CVE"].includes(t)?Math.round(e):["BHD","IQD","JOD","KWD","LYD","OMR","TND"].includes(t)?Math.round(1e3*e):Math.round(100*e);exports.convertToMinorUnits=convertToMinorUnits;const convertFromMinorUnits=(e,t)=>["JPY","KRW","VND","CLP","PYG","UGX","RWF","VUV","XAF","XOF","XPF","BIF","CLP","DJF","GNF","ISK","KMF","IDR","CVE"].includes(t)?e:["BHD","IQD","JOD","KWD","LYD","OMR","TND"].includes(t)?e/1e3:e/100;exports.convertFromMinorUnits=convertFromMinorUnits;const verifyHmacSignature=(e,t,r)=>{try{const o=crypto_1.default.createHmac("sha256",Buffer.from(r,"hex"));o.update(e,"utf8");return o.digest("base64")===t}catch(e){console_1.logger.error("ADYEN","Error verifying HMAC signature",e);return!1}};exports.verifyHmacSignature=verifyHmacSignature;const makeAdyenApiRequest=async(e,t,r)=>{const o=(0,exports.getAdyenApiUrl)(r.environment),n=(0,exports.getAdyenHeaders)(r.apiKey),s=await fetch(`${o}${e}`,{method:"POST",headers:n,body:JSON.stringify(t)});if(!s.ok){const e=await s.json().catch(()=>({}));throw(0,error_1.createError)({statusCode:400,message:`Adyen API error: ${s.status} - ${e.message||s.statusText}`})}return s.json()};exports.makeAdyenApiRequest=makeAdyenApiRequest;