"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const error_1=require("@b/utils/error"),utils_1=require("./utils"),query_1=require("@b/utils/query"),console_1=require("@b/utils/console");exports.metadata={summary:"Get price in USD for a currency",description:"Returns the price in USD for a given currency and wallet type.",operationId:"getCurrencyPriceInUSD",tags:["Finance","Currency"],logModule:"FINANCE",logTitle:"Get currency price in USD",parameters:[{name:"currency",in:"query",description:"The currency to get the price for",required:!0,schema:{type:"string"}},{name:"type",in:"query",description:"The wallet type of the currency",required:!0,schema:{type:"string"}}],requiresAuth:!0,responses:{200:{description:"Price in USD retrieved successfully",content:{"application/json":{schema:{type:"object",properties:{...utils_1.baseResponseSchema,data:{type:"number",description:"Price of the currency in USD"}}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Currency"),500:query_1.serverErrorResponse}};exports.default=async e=>{const{user:r,query:t,ctx:i}=e;if(!(null==r?void 0:r.id)){null==i||i.fail("User not authenticated");throw(0,error_1.createError)(401,"Unauthorized")}const{currency:o,type:n}=t;null==i||i.step("Validating price query parameters");if(!o||!n){console_1.logger.error("CURRENCY","Missing required parameters for price lookup",{currency:o,type:n});null==i||i.fail("Missing required query parameters");throw(0,error_1.createError)(400,"Missing required query parameters")}let c;try{null==i||i.step(`Fetching price for ${o} (${n})`);switch(n){case"FIAT":c=await(0,utils_1.getFiatPriceInUSD)(o);break;case"SPOT":c=await(0,utils_1.getSpotPriceInUSD)(o);break;case"ECO":c=await(0,utils_1.getEcoPriceInUSD)(o);break;default:console_1.logger.error("CURRENCY",`Invalid wallet type for price lookup: ${n}`);null==i||i.fail(`Invalid wallet type: ${n}`);throw(0,error_1.createError)(400,`Invalid type: ${n}`)}null==i||i.step("Validating price data");if(null==c||isNaN(c)){console_1.logger.error("CURRENCY",`Invalid price returned for ${o} (${n})`,{currency:o,type:n,priceUSD:c,priceType:typeof c});null==i||i.fail(`Price not found for ${o} (${n})`);throw(0,error_1.createError)(404,`Price not found for ${o} (${n})`)}if(0===c){console_1.logger.warn("CURRENCY",`Price is 0 for ${o} (${n}) - no trading activity or unlisted token`);null==i||i.warn(`Price is 0 for ${o} (${n})`)}null==i||i.success(`Retrieved price for ${o} (${n}): $${c}`);return{status:!0,message:"Price in USD retrieved successfully",data:c}}catch(e){console_1.logger.error("CURRENCY",`Error fetching price for ${o} (${n})`,e);e.statusCode||null==i||i.fail(`Error fetching price for ${o} (${n})`);throw e}};