"use strict";async function handleDeposit(e,r,a){const t=walletTypeToModel[e];if(!t){null==a||a.fail(`Invalid wallet type: ${e}`);throw(0,error_1.createError)(400,"Invalid wallet type")}let l=await t(r);switch(e){case"FIAT":const r=l.map(e=>({value:e.id,label:`${e.id} - ${e.name}`})).sort((e,r)=>e.label.localeCompare(r.label));null==a||a.success(`Retrieved ${r.length} FIAT currencies for deposit`);return r;case"SPOT":const t=l.map(e=>({value:e.currency,label:`${e.currency} - ${e.name}`})).sort((e,r)=>e.label.localeCompare(r.label));null==a||a.success(`Retrieved ${t.length} SPOT currencies for deposit`);return t;case"ECO":case"FUTURES":{const r=new Set;l=l.filter(e=>{const a=r.has(e.currency);r.add(e.currency);return!a});const t=l.map(e=>({value:e.currency,label:`${e.currency} - ${e.name}`,icon:e.icon})).sort((e,r)=>e.label.localeCompare(r.label));null==a||a.success(`Retrieved ${t.length} ${e} currencies for deposit`);return t}default:null==a||a.fail(`Invalid wallet type: ${e}`);throw(0,error_1.createError)(400,"Invalid wallet type")}}async function handleWithdraw(e,r,a=!0,t){const l=await db_1.models.wallet.findAll({where:{userId:r,type:e,balance:{[sequelize_1.Op.gt]:0}}});if(!l.length){null==t||t.fail(`No ${e} wallets found to withdraw from`);throw(0,error_1.createError)(404,`No ${e} wallets found to withdraw from`)}const n=[];for(const r of l){let a=!1;try{switch(e){case"FIAT":a=!!await db_1.models.currency.findOne({where:{id:r.currency,status:!0}});break;case"SPOT":a=!!await db_1.models.exchangeCurrency.findOne({where:{currency:r.currency,status:!0}});break;case"ECO":case"FUTURES":a=!!await db_1.models.ecosystemToken.findOne({where:{currency:r.currency,status:!0}});break;default:a=!1}a&&n.push(r)}catch(e){console_1.logger.warn("WALLET",`Error checking currency status for ${r.currency}`,e);null==t||t.warn(`Error checking currency status for ${r.currency}`)}}if(!n.length){null==t||t.fail(`No active ${e} currencies available for withdrawal`);throw(0,error_1.createError)(404,`No active ${e} currencies available for withdrawal`)}const s=n.map(e=>({value:e.currency,label:`${e.currency} - ${e.balance}`,balance:e.balance})).sort((e,r)=>e.label.localeCompare(r.label));null==t||t.success(`Retrieved ${s.length} ${e} currencies for withdrawal`);return s}async function handleTransfer(e,r,a,t=!0,l){const n=["FIAT","SPOT","ECO","FUTURES"];if(!n.includes(e)){null==l||l.fail(`Invalid source wallet type: ${e}`);throw(0,error_1.createError)(400,`Invalid source wallet type: ${e}`)}const s=await db_1.models.wallet.findAll({where:{userId:a,type:e,balance:{[sequelize_1.Op.gt]:0}}});if(!s.length){null==l||l.fail(`No ${e} wallets found to transfer from`);throw(0,error_1.createError)(404,`No ${e} wallets found to transfer from`)}const c=s.map(e=>({value:e.currency,label:`${e.currency} - ${e.balance}`})).sort((e,r)=>e.label.localeCompare(r.label));if(!r){null==l||l.success(`Retrieved ${c.length} source currencies for transfer`);return{from:c,to:[]}}if(!n.includes(r)){null==l||l.fail(`Invalid target wallet type: ${r}`);throw(0,error_1.createError)(400,`Invalid target wallet type: ${r}`)}let o=[];switch(r){case"FIAT":o=(await db_1.models.currency.findAll({where:{status:!0}})).map(e=>({value:e.id,label:`${e.id} - ${e.name}`})).sort((e,r)=>e.label.localeCompare(r.label));break;case"SPOT":o=(await db_1.models.exchangeCurrency.findAll({where:{status:!0}})).map(e=>({value:e.currency,label:`${e.currency} - ${e.name}`})).sort((e,r)=>e.label.localeCompare(r.label));break;case"ECO":case"FUTURES":o=(await db_1.models.ecosystemToken.findAll({where:{status:!0}})).map(e=>({value:e.currency,label:`${e.currency} - ${e.name}`})).sort((e,r)=>e.label.localeCompare(r.label));break;default:null==l||l.fail(`Invalid wallet type: ${r}`);throw(0,error_1.createError)(400,"Invalid wallet type")}null==l||l.success(`Retrieved ${c.length} source and ${o.length} target currencies for transfer`);return{from:c,to:o}}Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const error_1=require("@b/utils/error"),utils_1=require("./utils"),query_1=require("@b/utils/query"),db_1=require("@b/db"),sequelize_1=require("sequelize"),cache_1=require("@b/utils/cache"),console_1=require("@b/utils/console");exports.metadata={summary:"Lists all currencies with their current rates",description:"This endpoint retrieves all available currencies along with their current rates.",operationId:"getCurrencies",tags:["Finance","Currency"],logModule:"FINANCE",logTitle:"Get currencies by action",parameters:[{name:"action",in:"query",description:"The action to perform",required:!1,schema:{type:"string"}},{name:"walletType",in:"query",description:"The type of wallet to retrieve currencies for",required:!0,schema:{type:"string",enum:["FIAT","SPOT","ECO","FUTURES"]}},{name:"targetWalletType",in:"query",description:"The type of wallet to transfer to (optional for transfer action)",required:!1,schema:{type:"string",enum:["FIAT","SPOT","ECO","FUTURES"]}}],requiresAuth:!0,responses:{200:{description:"Currencies retrieved successfully",content:{"application/json":{schema:{type:"object",properties:{...utils_1.baseResponseSchema,data:{type:"array",items:{type:"object",properties:utils_1.baseCurrencySchema}}}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Currency"),500:query_1.serverErrorResponse}};const walletTypeToModel={FIAT:async e=>db_1.models.currency.findAll({where:e}),SPOT:async e=>db_1.models.exchangeCurrency.findAll({where:e}),ECO:async e=>db_1.models.ecosystemToken.findAll({where:e}),FUTURES:async e=>db_1.models.ecosystemToken.findAll({where:e})};exports.default=async e=>{const{user:r,query:a,ctx:t}=e;if(!(null==r?void 0:r.id)){null==t||t.fail("User not authenticated");throw(0,error_1.createError)(401,"Unauthorized")}const{action:l,walletType:n,targetWalletType:s}=a;null==t||t.step("Checking wallet configuration");const c=cache_1.CacheManager.getInstance(),o=await c.getSetting("spotWallets"),i=await c.getSetting("fiatWallets"),u=!0===o||"true"===o,d=!0===i||"true"===i,y=(await c.getExtensions()).has("ecosystem");if(!u&&("SPOT"===n||"SPOT"===s)){null==t||t.warn("SPOT wallets are disabled");return[]}if(!d&&("FIAT"===n||"FIAT"===s)){null==t||t.warn("FIAT wallets are disabled");return[]}if(!y&&("ECO"===n||"ECO"===s)){null==t||t.warn("Ecosystem extension is not enabled");return[]}const w={status:!0};null==t||t.step(`Processing ${l} action for ${n} wallet`);switch(l){case"deposit":return handleDeposit(n,w,t);case"withdraw":case"payment":return handleWithdraw(n,r.id,u,t);case"transfer":return handleTransfer(n,s,r.id,u,t);default:null==t||t.fail(`Invalid action: ${l}`);throw(0,error_1.createError)(400,"Invalid action")}};