"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),query_1=require("@b/utils/query");exports.metadata={summary:"Add Item to Watchlist",operationId:"addWatchlistItem",tags:["Exchange","Watchlist"],description:"Adds a new item to the watchlist for the authenticated user.",requestBody:{description:"Data for the watchlist item to add.",content:{"application/json":{schema:{type:"object",properties:{symbol:{type:"string",description:"Symbol of the watchlist item"}},required:["symbol"]}}},required:!0},responses:(0,query_1.createRecordResponses)("Watchlist"),requiresAuth:!0,logModule:"EXCHANGE",logTitle:"Toggle watchlist item"};exports.default=async e=>{const{user:t,body:s,ctx:r}=e;if(!(null==t?void 0:t.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});const{symbol:i}=s;null==r||r.step("Validating watchlist parameters");if(!i)throw(0,error_1.createError)({statusCode:400,message:"Missing required parameters: symbol."});null==r||r.step(`Checking if ${i} is already in watchlist`);const a=await db_1.models.exchangeWatchlist.findOne({where:{userId:t.id,symbol:i}});if(a){null==r||r.step(`Removing ${i} from watchlist`);await db_1.models.exchangeWatchlist.destroy({where:{id:a.id}});null==r||r.success(`Removed ${i} from watchlist`);return{message:"Item removed from watchlist successfully"}}null==r||r.step(`Adding ${i} to watchlist`);await db_1.models.exchangeWatchlist.create({userId:t.id,symbol:i});null==r||r.success(`Added ${i} to watchlist`);return{message:"Item added to watchlist successfully"}};