"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),query_1=require("@b/utils/query"),utils_1=require("../utils");exports.metadata={summary:"List Watchlist Items",operationId:"listWatchlistItems",tags:["Exchange","Watchlist"],description:"Retrieves a list of watchlist items for the authenticated user.",logModule:"EXCHANGE",logTitle:"List Watchlist",responses:{200:{description:"A list of watchlist items",content:{"application/json":{schema:{type:"array",items:{type:"object",properties:utils_1.baseWatchlistItemSchema}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Watchlist"),500:query_1.serverErrorResponse},requiresAuth:!0};exports.default=async e=>{const{user:t,ctx:s}=e;if(!(null==t?void 0:t.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});null==s||s.step("Fetching watchlist items");const r=await db_1.models.exchangeWatchlist.findAll({where:{userId:t.id}});null==s||s.success(`Retrieved ${r.length} watchlist items`);return r.map(e=>e.get({plain:!0}))};