"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const redis_1=require("@b/utils/redis"),query_1=require("@b/utils/query"),utils_1=require("../utils"),error_1=require("@b/utils/error"),redis=redis_1.RedisSingleton.getInstance();exports.metadata={summary:"Get All Market Tickers",operationId:"getAllMarketTickers",tags:["Exchange","Markets"],description:"Retrieves ticker information for all available market pairs.",logModule:"EXCHANGE",logTitle:"Get Market Tickers",responses:{200:{description:"All market tickers information",content:{"application/json":{schema:{type:"object",properties:utils_1.baseTickerSchema}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Ticker"),500:query_1.serverErrorResponse}};exports.default=async e=>{const{ctx:r}=e;null==r||r.step("Retrieving tickers from cache");const t=await redis.get("exchange:tickers");if(!t)throw(0,error_1.createError)(404,"No tickers found in cache");const s=JSON.parse(t||"{}"),i=Object.keys(s).length;null==r||r.success(`Retrieved ${i} market tickers`);return s};