"use strict";async function getHistoricalOHLCV(e,t,a,r,i,n=3,o=1e3){try{const i=await(0,utils_2.loadBanStatus)(),l=await(0,utils_2.handleBanStatus)(i);let s=await(0,utils_1.getCachedOHLCV)(e,t,a,r);s=(0,utils_1.validateAndCleanCandles)(s);const c=(0,utils_1.intervalToMilliseconds)(t),u=Math.ceil((r-a)/c);console_1.logger.debug("CHART",`${e}/${t}: Cached ${s.length} candles, expected ~${u}`);if(l){console_1.logger.info("CHART",`Exchange banned, returning cached data for ${e}/${t}`);return s}let g=null;try{g=await Promise.race([exchange_1.default.startExchange(),new Promise((e,t)=>setTimeout(()=>t(new Error("Exchange initialization timeout")),1e4))])}catch(e){console_1.logger.warn("CHART",`Exchange init failed: ${e.message}`)}if(!g){console_1.logger.warn("CHART","Exchange not available, returning cached data only");return s}const d=s.length>0?s[s.length-1][0]:0,h=d>Date.now()-2*c;if(s.length>=.9*u&&h){console_1.logger.debug("CHART",`${e}/${t}: Cache sufficient and recent, returning ${s.length} candles`);return s}s.length>=.9*u&&!h&&console_1.logger.info("CHART",`${e}/${t}: Cache has ${s.length} candles but last candle is ${Math.round((Date.now()-d)/6e4)} minutes old. Fetching recent data.`);const m=(0,utils_1.findGapsInCachedData)(s,a,r,t),f=Date.now(),p=Math.floor(f/c)*c;if(0===m.length){console_1.logger.debug("CHART",`${e}/${t}: No gaps found, returning cached data`);return s}if((0,utils_1.isGapFillInProgress)(e,t)){console_1.logger.info("CHART",`${e}/${t}: Gap fill already in progress, waiting for completion`);const i=await(0,utils_1.waitForGapFill)(e,t);if(i)return i;let n=await(0,utils_1.getCachedOHLCV)(e,t,a,r);n=(0,utils_1.validateAndCleanCandles)(n);return n}if(!(0,utils_1.registerGapFillOperation)(e,t,m)){console_1.logger.info("CHART",`${e}/${t}: Duplicate gap fill request, waiting for existing operation`);await(0,utils_1.waitForGapFill)(e,t);let i=await(0,utils_1.getCachedOHLCV)(e,t,a,r);i=(0,utils_1.validateAndCleanCandles)(i);return i}return await(0,utils_1.executeWithGapFillLock)(e,t,async()=>{try{const i=m.reduce((e,t)=>e+(t.gapEnd-t.gapStart)/6e4,0);console_1.logger.info("CHART",`${e}/${t}: Found ${m.length} gaps (${Math.round(i)} min total) to fill from exchange API`);m.forEach((e,t)=>{console_1.logger.debug("CHART",`  Gap ${t+1}: ${new Date(e.gapStart).toISOString()} to ${new Date(e.gapEnd).toISOString()} (${Math.round((e.gapEnd-e.gapStart)/6e4)} min)`)});let l=0;for(const{gapStart:a,gapEnd:r}of m){let i=a,s=o;for(;i<r;){if(await(0,utils_2.handleBanStatus)(await(0,utils_2.loadBanStatus)())){console_1.logger.warn("CHART","Exchange became banned during fetch, stopping");break}for(let a=1;a<=n;a++)try{const a=Math.min(r,p);if(i>=a){console_1.logger.debug("CHART",`fetchStart (${new Date(i).toISOString()}) >= adjustedFetchEnd (${new Date(a).toISOString()}), breaking`);break}console_1.logger.debug("CHART",`Fetching OHLCV from ${new Date(i).toISOString()}, limit 500`);const n=await Promise.race([g.fetchOHLCV(e,t,i,500),new Promise((e,t)=>setTimeout(()=>t(new Error("fetchOHLCV timeout")),15e3))]);n&&n.length>0&&console_1.logger.debug("CHART",`Received ${n.length} candles: ${new Date(n[0][0]).toISOString()} to ${new Date(n[n.length-1][0]).toISOString()}`);if(n&&n.length>0){const a=(0,utils_1.validateAndCleanCandles)(n);if(a.length>0){await(0,utils_1.saveOHLCVToCache)(e,t,a);l+=a.length;i=a[a.length-1][0]+c;console_1.logger.debug("CHART",`${e}/${t}: Fetched ${a.length} candles (total: ${l})`)}else i+=100*c}else i+=100*c;break}catch(e){console_1.logger.warn("CHART",`Attempt ${a} failed for fetch starting at ${i}: ${e.message}`);if(a<n){await new Promise(e=>setTimeout(e,s));s=Math.min(1.5*s,5e3)}else{console_1.logger.error("CHART",`Failed to fetch data starting at ${i} after ${n} attempts, skipping chunk`);i=Math.min(i+500*c,r)}}await new Promise(e=>setTimeout(e,100))}}console_1.logger.info("CHART",`${e}/${t}: Total fetched ${l} candles from exchange API`);let s=await(0,utils_1.getCachedOHLCV)(e,t,a,r);s=(0,utils_1.validateAndCleanCandles)(s);s=(0,utils_1.repairCandleData)(s,t);const d=(0,utils_1.findGapsInCachedData)(s,a,r,t);if(d.length>0){const i=d.reduce((e,t)=>e+Math.ceil((t.gapEnd-t.gapStart)/c),0);if(i<.05*u){console_1.logger.info("CHART",`${e}/${t}: ${i} candles still missing (<5%), filling with synthetic`);return(0,utils_1.fillGapsWithSyntheticCandles)(s,a,r,t)}console_1.logger.warn("CHART",`${e}/${t}: ${i} candles still missing (${Math.round(i/u*100)}%), returning partial data`)}return s}finally{(0,utils_1.clearGapFillOperation)(e,t)}})}catch(i){console_1.logger.error("CHART",`Error in getHistoricalOHLCV: ${i}`);(0,utils_1.clearGapFillOperation)(e,t);try{let i=await(0,utils_1.getCachedOHLCV)(e,t,a,r);i=(0,utils_1.validateAndCleanCandles)(i);return i}catch(e){console_1.logger.error("CHART",`Failed to get cached data as fallback: ${e}`);return[]}}}var __importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;exports.getHistoricalOHLCV=getHistoricalOHLCV;const exchange_1=__importDefault(require("@b/utils/exchange")),query_1=require("@b/utils/query"),utils_1=require("./utils"),utils_2=require("../utils"),console_1=require("@b/utils/console"),error_1=require("@b/utils/error");exports.metadata={summary:"Get Historical Chart Data",operationId:"getHistoricalChartData",tags:["Chart","Historical"],description:"Retrieves historical chart data for the authenticated user.",logModule:"EXCHANGE",logTitle:"Get Chart Data",parameters:[{name:"symbol",in:"query",description:"Symbol to retrieve data for.",required:!0,schema:{type:"string"}},{name:"interval",in:"query",description:"Interval to retrieve data for.",required:!0,schema:{type:"string"}},{name:"from",in:"query",description:"Start timestamp to retrieve data from.",required:!0,schema:{type:"number"}},{name:"to",in:"query",description:"End timestamp to retrieve data from.",required:!0,schema:{type:"number"}},{name:"duration",in:"query",description:"Duration to retrieve data for.",required:!0,schema:{type:"number"}}],responses:{200:{description:"Historical chart data retrieved successfully",content:{"application/json":{schema:{type:"array",items:{type:"object",properties:utils_1.baseChartDataPointSchema}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Chart"),500:query_1.serverErrorResponse}};const activeRequests=new Map;exports.default=async e=>{const{query:t,ctx:a}=e;if(!(t.symbol&&t.interval&&t.from&&t.to&&t.duration))throw(0,error_1.createError)({statusCode:400,message:"Missing required parameters: symbol, interval, from, to, duration"});const r=Number(t.from),i=Number(t.to),{from:n,to:o,isValid:l}=(0,utils_1.validateAndNormalizeTimestamps)(r,i);l||console_1.logger.warn("CHART",`Invalid timestamps received for ${t.symbol}: from=${r}, to=${i}. Using normalized values: from=${n}, to=${o}`);const s=`${t.symbol}-${t.interval}-${n}-${o}`;if(activeRequests.has(s)){console_1.logger.debug("CHART",`Deduplicating request for ${s}`);return await activeRequests.get(s)}null==a||a.step(`Fetching chart data for ${t.symbol} (${t.interval})`);const c=new Promise((e,t)=>{setTimeout(()=>t(new Error("Request timeout after 20 seconds")),2e4)}),u=getHistoricalOHLCV(t.symbol,t.interval,n,o,Number(t.duration));activeRequests.set(s,u);try{const e=await Promise.race([u,c]);null==a||a.success(`Retrieved ${e.length} chart data points`);return e}catch(e){console_1.logger.error("CHART",`API error for ${s}: ${e.message}`);throw e}finally{activeRequests.delete(s)}};