"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),query_1=require("@b/utils/query"),sequelize_1=require("sequelize"),error_1=require("@b/utils/error");exports.metadata={summary:"List Orders",operationId:"listOrders",tags:["Exchange","Orders"],description:"Retrieves a list of orders for the authenticated user with pagination support.",logModule:"EXCHANGE",logTitle:"List Binary Orders",parameters:[{name:"type",in:"query",description:"Type of order to retrieve.",schema:{type:"string"}},{name:"currency",in:"query",description:"currency of the order to retrieve.",schema:{type:"string"}},{name:"pair",in:"query",description:"pair of the order to retrieve.",schema:{type:"string"}},{name:"limit",in:"query",description:"Maximum number of orders to return (default: 50, max: 200)",schema:{type:"number"}},{name:"offset",in:"query",description:"Number of orders to skip for pagination (default: 0)",schema:{type:"number"}}],responses:{200:{description:"A paginated list of orders",content:{"application/json":{schema:{type:"object",properties:{orders:{type:"array",items:{type:"object",properties:{}}},pagination:{type:"object",properties:{total:{type:"number",description:"Total number of orders matching the criteria"},limit:{type:"number",description:"Maximum number of orders per page"},offset:{type:"number",description:"Number of orders skipped"},hasMore:{type:"boolean",description:"Whether there are more orders available"}}}}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Order"),500:query_1.serverErrorResponse},requiresAuth:!0};exports.default=async e=>{const{user:r,query:t,ctx:i}=e;if(!(null==r?void 0:r.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});const{currency:o,pair:s,type:a,limit:n,offset:d}=t,p=Math.min(Math.max(1,parseInt(n)||50),200),u=Math.max(0,parseInt(d)||0),m={userId:r.id,status:"OPEN"===a?"PENDING":{[sequelize_1.Op.not]:"PENDING"},symbol:`${o}/${s}`};null==i||i.step(`Fetching ${a} binary orders for ${o}/${s} (limit: ${p}, offset: ${u})`);const c=await db_1.models.binaryOrder.count({where:m}),l=await db_1.models.binaryOrder.findAll({where:m,order:[["createdAt","DESC"]],limit:p,offset:u}),y=u+l.length<c;null==i||i.success(`Retrieved ${l.length} of ${c} binary orders`);return{orders:l,pagination:{total:c,limit:p,offset:u,hasMore:y}}};