"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const date_fns_1=require("date-fns"),db_1=require("@b/db"),cache_1=require("@b/utils/cache");exports.metadata={summary:"Binary Trading Health Check",operationId:"binaryHealthCheck",tags:["Binary","Health"],description:"Checks the health status of the binary trading system including database connectivity, order processing, and system configuration.",responses:{200:{description:"Health check completed successfully",content:{"application/json":{schema:{type:"object",properties:{status:{type:"string",enum:["healthy","degraded","down"],description:"Overall system health status"},timestamp:{type:"string",description:"ISO 8601 timestamp of health check"},checks:{type:"object",properties:{system:{type:"object"},database:{type:"object"},durations:{type:"object"},markets:{type:"object"},orders:{type:"object"}}}}}}}},500:{description:"Health check failed"}},requiresAuth:!1,logModule:"BINARY_HEALTH",logTitle:"Binary Trading Health Check"};exports.default=async e=>{const{ctx:t}=e,s=(0,date_fns_1.formatDate)(new Date,"yyyy-MM-dd HH:mm:ss"),a={system:{status:"up",message:""},database:{status:"up",message:""},durations:{status:"up",message:""},markets:{status:"up",message:""},orders:{status:"up",message:""}};try{null==t||t.step("Checking binary trading system status");const e=cache_1.CacheManager.getInstance(),n="true"===await e.getSetting("binaryStatus");a.system=n?{status:"up",message:"Binary trading is enabled",details:{enabled:!0}}:{status:"down",message:"Binary trading is disabled in system configuration",details:{enabled:!1}};null==t||t.step("Checking database connectivity");try{await db_1.sequelize.authenticate();a.database={status:"up",message:"Database connection is healthy"}}catch(e){a.database={status:"down",message:`Database connection failed: ${e.message}`}}null==t||t.step("Checking binary durations");try{const e=await db_1.models.binaryDuration.findAll({where:{status:!0},attributes:["id","duration","status"]});0===e.length?a.durations={status:"warning",message:"No active binary durations found",details:{count:0,active:0}}:a.durations={status:"up",message:`${e.length} active duration(s) available`,details:{count:e.length,durations:e.map(e=>`${e.duration}m`).join(", ")}}}catch(e){a.durations={status:"down",message:`Failed to fetch durations: ${e.message}`}}null==t||t.step("Checking binary markets");try{const e=await db_1.models.binaryMarket.count({where:{status:"ACTIVE"}});a.markets=0===e?{status:"warning",message:"No active binary markets found",details:{active:0}}:{status:"up",message:`${e} active market(s) available`,details:{active:e}}}catch(e){a.markets={status:"down",message:`Failed to fetch markets: ${e.message}`}}null==t||t.step("Checking order processing health");try{const e=await db_1.models.binaryOrder.count({where:{status:"PENDING"}}),t=new Date(Date.now()-864e5),s=await db_1.models.binaryOrder.count({where:{status:"PENDING",createdAt:{[db_1.models.Sequelize.Op.lt]:t}}});a.orders=s>0?{status:"warning",message:`${s} order(s) stuck in pending status for >24h`,details:{pending:e,stuck:s}}:{status:"up",message:`Order processing healthy. ${e} pending order(s)`,details:{pending:e,stuck:0}}}catch(e){a.orders={status:"down",message:`Failed to check orders: ${e.message}`}}const i=Object.values(a).map(e=>e.status);let r;r=i.includes("down")?"down":i.includes("warning")?"degraded":"healthy";null==t||t.success(`Binary trading health check completed: ${r}`);return{status:r,timestamp:s,checks:a}}catch(e){null==t||t.fail(`Health check failed: ${e.message}`);return{status:"down",timestamp:s,checks:{...a,system:{status:"down",message:`Unexpected error during health check: ${e.message}`}}}}};