"use strict";async function safeCount(e,t={}){try{return e?await e.count({where:t}):0}catch(e){return 0}}async function safeSum(e,t,a={}){try{if(!e)return 0;return await e.sum(t,{where:a})||0}catch(e){return 0}}function formatNumber(e){return e>=1e6?`${(e/1e6).toFixed(1)}M`:e>=1e3?`${(e/1e3).toFixed(1)}K`:e.toString()}function formatValue(e){return e>=1e9?`$${(e/1e9).toFixed(2)}B`:e>=1e6?`$${(e/1e6).toFixed(2)}M`:e>=1e3?`$${(e/1e3).toFixed(2)}K`:`$${e.toFixed(2)}`}Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const cache_1=require("@b/utils/cache"),db_1=require("@b/db"),sequelize_1=require("sequelize"),query_1=require("@b/utils/query");exports.metadata={summary:"Get landing page statistics based on enabled extensions",description:"Returns platform statistics and features based on enabled extensions and settings",operationId:"getLandingStats",tags:["Content"],requiresAuth:!1,responses:{200:{description:"Landing page statistics retrieved successfully",content:{"application/json":{schema:{type:"object",properties:{platform:{type:"object"},extensions:{type:"object"},features:{type:"array"}}}}}},500:query_1.serverErrorResponse}};exports.default=async()=>{var e;try{const t=cache_1.CacheManager.getInstance(),a=await t.getExtensions(),s=Array.from(a.keys()),r=await t.getSetting("spotWallets"),o=!0===r||"true"===r,[i,n]=await Promise.all([safeCount(db_1.models.user),safeCount(db_1.models.user,{status:"ACTIVE"})]),l={platform:{users:i,activeUsers:n,verified:0},extensions:{},features:[],settings:{spotEnabled:o}};try{const t=await(null===(e=db_1.models.kyc)||void 0===e?void 0:e.count({where:{status:"APPROVED"}}));l.platform.verified=t||0}catch(e){}if(o)try{const[e,t]=await Promise.all([safeSum(db_1.models.exchangeOrder,"cost",{status:"CLOSED"}),safeCount(db_1.models.exchangeOrder)]);l.extensions.spot={enabled:!0,volume:e,orders:t};l.features.push({id:"spot",title:"Spot Trading",description:"Trade cryptocurrencies instantly with real-time market data and advanced charting tools.",icon:"TrendingUp",gradient:"from-blue-500 to-cyan-500",stats:[{label:"Trading Volume",value:formatValue(e),icon:"DollarSign"},{label:"Total Orders",value:formatNumber(t),icon:"Activity"}],link:"/trade"})}catch(e){}if(s.includes("binary"))try{const[e,t]=await Promise.all([safeCount(db_1.models.binaryOrder),safeSum(db_1.models.binaryOrder,"amount")]);l.extensions.binary={enabled:!0,orders:e,volume:t};l.features.push({id:"binary",title:"Binary Options",description:"Predict market movements and earn high returns with our binary options trading platform.",icon:"Target",gradient:"from-purple-500 to-pink-500",stats:[{label:"Total Trades",value:formatNumber(e),icon:"Activity"},{label:"Volume",value:formatValue(t),icon:"DollarSign"}],link:"/binary"})}catch(e){}if(s.includes("futures"))try{const[e,t]=await Promise.all([safeCount(db_1.models.futuresMarket,{status:!0}),safeCount(db_1.models.futuresPosition)]);l.extensions.futures={enabled:!0,markets:e,positions:t};l.features.push({id:"futures",title:"Futures Trading",description:"Trade perpetual futures with up to 100x leverage on major cryptocurrency pairs.",icon:"Rocket",gradient:"from-orange-500 to-red-500",stats:[{label:"Markets",value:formatNumber(e),icon:"BarChart3"},{label:"Positions",value:formatNumber(t),icon:"Layers"}],link:"/futures"})}catch(e){}if(s.includes("ecosystem"))try{const[e,t]=await Promise.all([safeCount(db_1.models.ecosystemToken,{status:!0}),safeCount(db_1.models.ecosystemMarket,{status:!0})]);l.extensions.ecosystem={enabled:!0,tokens:e,markets:t};l.features.push({id:"ecosystem",title:"Native Tokens",description:"Trade native blockchain tokens with direct wallet integration and low fees.",icon:"Layers",gradient:"from-emerald-500 to-teal-500",stats:[{label:"Tokens",value:formatNumber(e),icon:"Coins"},{label:"Markets",value:formatNumber(t),icon:"BarChart3"}],link:"/ecosystem"})}catch(e){}if(s.includes("staking"))try{const[e,t,a,s,r]=await Promise.all([safeCount(db_1.models.stakingPool,{status:"ACTIVE"}),safeSum(db_1.models.stakingPosition,"amount",{status:"ACTIVE"}),safeCount(db_1.models.stakingPosition,{status:"ACTIVE"}),db_1.models.stakingPool.findAll({where:{status:"ACTIVE"},attributes:["id","name","currency","minStake","lockPeriod"],order:[["createdAt","DESC"]],limit:3,raw:!0}).catch(()=>[]),db_1.models.stakingDuration.findOne({attributes:[[(0,sequelize_1.fn)("MAX",(0,sequelize_1.col)("interestRate")),"maxApr"]],raw:!0}).catch(()=>null)]),o=await Promise.all(s.map(async e=>{const t=await db_1.models.stakingDuration.findOne({where:{poolId:e.id},attributes:["interestRate"],order:[["interestRate","DESC"]],raw:!0}).catch(()=>null);return{name:e.name,symbol:e.currency,apr:(null==t?void 0:t.interestRate)||0,minStake:e.minStake||0,lockPeriod:e.lockPeriod||0}}));l.extensions.staking={enabled:!0,pools:e,totalStaked:t,positions:a};l.features.push({id:"staking",title:"Staking Pools",description:"Earn passive income by staking your crypto assets in our high-yield staking pools.",icon:"Percent",gradient:"from-green-500 to-emerald-500",stats:[{label:"Active Pools",value:formatNumber(e),icon:"Database"},{label:"Total Staked",value:formatValue(t),icon:"Lock"}],link:"/staking",data:{featuredPools:o,highestApr:(null==r?void 0:r.maxApr)||0}})}catch(e){}if(s.includes("ico"))try{const[e,t]=await Promise.all([safeCount(db_1.models.icoTokenOffering,{status:"ACTIVE"}),safeSum(db_1.models.icoTransaction,"amount",{status:"COMPLETED"})]);l.extensions.ico={enabled:!0,offerings:e,raised:t};e>0&&l.features.push({id:"ico",title:"Token Offerings",description:"Participate in token sales and get early access to promising blockchain projects.",icon:"Rocket",gradient:"from-amber-500 to-orange-500",stats:[{label:"Active Offerings",value:formatNumber(e),icon:"Flame"},{label:"Total Raised",value:formatValue(t),icon:"TrendingUp"}],link:"/ico"})}catch(e){}if(s.includes("ai"))try{const[e,t,a]=await Promise.all([safeCount(db_1.models.aiInvestmentPlan,{status:!0}),safeSum(db_1.models.aiInvestment,"amount",{status:"ACTIVE"}),safeCount(db_1.models.aiInvestment,{status:"ACTIVE"})]);l.extensions.ai={enabled:!0,plans:e,invested:t,investors:a};l.features.push({id:"ai",title:"AI Investment",description:"Let our AI-powered algorithms grow your investment with automated trading strategies.",icon:"Brain",gradient:"from-violet-500 to-purple-500",stats:[{label:"Investment Plans",value:formatNumber(e),icon:"Sparkles"},{label:"Total Invested",value:formatValue(t),icon:"TrendingUp"}],link:"/ai/investment"})}catch(e){}if(s.includes("copy-trading"))try{const[e,t,a]=await Promise.all([safeCount(db_1.models.copyTradingLeader,{status:"ACTIVE"}),safeCount(db_1.models.copyTradingFollower,{status:"ACTIVE"}),safeSum(db_1.models.copyTradingTrade,"amount")]);l.extensions.copyTrading={enabled:!0,leaders:e,followers:t,volume:a};l.features.push({id:"copyTrading",title:"Copy Trading",description:"Follow successful traders and automatically copy their trades to your portfolio.",icon:"Copy",gradient:"from-cyan-500 to-blue-500",stats:[{label:"Pro Traders",value:formatNumber(e),icon:"Award"},{label:"Followers",value:formatNumber(t),icon:"Users"}],link:"/copy-trading"})}catch(e){}if(s.includes("affiliate"))try{const[e,t]=await Promise.all([safeCount(db_1.models.mlmReferral),safeSum(db_1.models.mlmReferralReward,"reward")]);l.extensions.affiliate={enabled:!0,affiliates:e,earnings:t};l.features.push({id:"affiliate",title:"Affiliate Program",description:"Earn commissions by referring friends and building your affiliate network.",icon:"Gift",gradient:"from-rose-500 to-pink-500",stats:[{label:"Affiliates",value:formatNumber(e),icon:"Users"},{label:"Total Earnings",value:formatValue(t),icon:"DollarSign"}],link:"/affiliate"})}catch(e){}if(s.includes("gateway"))try{const[e,t]=await Promise.all([safeCount(db_1.models.gatewayMerchant,{status:"ACTIVE"}),safeCount(db_1.models.gatewayPayment,{status:"COMPLETED"})]);l.extensions.gateway={enabled:!0,merchants:e,payments:t}}catch(e){}return l}catch(e){console.error("Landing stats error:",e);return query_1.serverErrorResponse}};