"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),query_1=require("@b/utils/query");exports.metadata={summary:"Bulk deletes posts by IDs",operationId:"bulkDeletePosts",tags:["Content","Author","Post"],logModule:"BLOG",logTitle:"Bulk delete author posts",parameters:[...(0,query_1.commonBulkDeleteParams)("Posts")],requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{ids:{type:"array",items:{type:"string"},description:"Array of post IDs to delete"}},required:["ids"]}}}},responses:(0,query_1.commonBulkDeleteResponses)("Posts"),requiresAuth:!0};exports.default=async e=>{const{body:t,query:r,user:s,params:o,ctx:u}=e;if(!(null==s?void 0:s.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});const{ids:a}=t;null==u||u.step("Verifying author credentials");const d=await db_1.models.author.findOne({where:{userId:s.id}});if(!d)throw(0,error_1.createError)({statusCode:404,message:"Author not found"});null==u||u.step(`Deleting ${a.length} post(s)`);const l=await(0,query_1.handleBulkDelete)({model:"post",ids:a,query:r,where:{authorId:d.id}});null==u||u.success(`Bulk deleted ${a.length} post(s) for author ${d.id}`);return l};