"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const cache_1=require("@b/utils/cache"),db_1=require("@b/db"),error_1=require("@b/utils/error"),query_1=require("@b/utils/query");exports.metadata={summary:"Creates a new author",description:"This endpoint creates a new author.",operationId:"createAuthor",tags:["Content","Author"],logModule:"BLOG",logTitle:"Apply as author",requiresAuth:!0,responses:(0,query_1.createRecordResponses)("Author")};exports.default=async e=>{const{user:r,ctx:t}=e;if(!(null==r?void 0:r.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});null==t||t.step("Checking author application settings");const o=cache_1.CacheManager.getInstance(),a=await o.getSettings(),s=a.has("autoApproveAuthors")?a.get("autoApproveAuthors"):null,u="boolean"==typeof s?s:Boolean(s);null==t||t.step("Checking for existing author profile");if(await db_1.models.author.findOne({where:{userId:r.id}}))throw(0,error_1.createError)({statusCode:400,message:"Author profile already exists"});null==t||t.step("Creating author profile");await db_1.models.author.create({userId:r.id,status:u?"APPROVED":"PENDING"});null==t||t.success(`Author profile created for user ${r.id} - ${u?"auto-approved":"pending approval"}`);return{message:"Author created successfully"}};