"use strict";async function verifySignature({address:e,message:r,signature:s,chainId:t,projectId:o}){try{const a=(0,viem_1.createPublicClient)({transport:(0,viem_1.http)(`https://rpc.walletconnect.org/v1/?chainId=${t}&projectId=${o}`)});return await a.verifyMessage({message:r,address:e,signature:s})}catch(e){console_1.logger.error("AUTH","Signature verification error",e);return!1}}function validateEmail(e){return/^[a-zA-Z0-9._-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,4}$/.test(e)}async function getOrCreateUserRole(){await db_1.models.role.upsert({name:"User"});return await db_1.models.role.findOne({where:{name:"User"}})}async function createUser(e){return await db_1.models.user.create({firstName:e.firstName,lastName:e.lastName,email:e.email,password:e.hashedPassword,emailVerified:!0,roleId:e.role.id,settings:{email:!0,sms:!1,push:!1}})}async function updateUser(e,r){await db_1.models.user.update({firstName:r.firstName,lastName:r.lastName,password:r.hashedPassword,emailVerified:!0},{where:{id:e}})}async function createSessionAndReturnResponse(e){const r={id:e.id,role:e.roleId},s=await(0,token_1.generateAccessToken)(r),t=await(0,token_1.generateRefreshToken)(r),o=(0,token_1.generateCsrfToken)();return{message:"You have been logged in successfully",cookies:{accessToken:s,refreshToken:t,sessionId:(await(0,token_1.createSession)(e.id,e.roleId,s,o,t)).sid,csrfToken:o}}}async function generateNewPassword(e){const r=generate_password_1.default.generate({length:20,numbers:!0,symbols:!0,strict:!0});if(!(0,passwords_1.validatePassword)(r))return(0,error_1.createError)({statusCode:500,message:"Server error"});const s=await(0,passwords_1.hashPassword)(r);try{await db_1.models.user.update({password:s},{where:{id:e}});return r}catch(e){throw(0,error_1.createError)({statusCode:500,message:"Server error"})}}async function addOneTimeToken(e,r){try{await db_1.models.oneTimeToken.create({tokenId:e,expiresAt:r});return e}catch(e){throw(0,error_1.createError)({statusCode:500,message:"Server error"})}}function getAddressFromMessage(e){var r;return(null===(r=e.match(ETH_ADDRESS_PATTERN))||void 0===r?void 0:r[0])||""}function getChainIdFromMessage(e){var r;return`eip155:${(null===(r=e.match(ETH_CHAIN_ID_IN_SIWE_PATTERN))||void 0===r?void 0:r[1])||1}`}var __importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0});exports.getUserByWalletAddress=exports.verifyResetTokenQuery=exports.sendEmailVerificationToken=exports.userInclude=exports.returnUserWithTokens=exports.userRegisterSchema=exports.userRegisterResponseSchema=void 0;exports.verifySignature=verifySignature;exports.validateEmail=validateEmail;exports.getOrCreateUserRole=getOrCreateUserRole;exports.createUser=createUser;exports.updateUser=updateUser;exports.createSessionAndReturnResponse=createSessionAndReturnResponse;exports.generateNewPassword=generateNewPassword;exports.addOneTimeToken=addOneTimeToken;exports.getAddressFromMessage=getAddressFromMessage;exports.getChainIdFromMessage=getChainIdFromMessage;const error_1=require("@b/utils/error"),passwords_1=require("@b/utils/passwords"),db_1=require("@b/db"),token_1=require("@b/utils/token"),generate_password_1=__importDefault(require("generate-password")),emails_1=require("@b/utils/emails"),viem_1=require("viem"),console_1=require("@b/utils/console");exports.userRegisterResponseSchema={message:{type:"string",description:"Success message"},cookies:{type:"object",properties:{accessToken:{type:"string",description:"Access token"},sessionId:{type:"string",description:"Session ID"},csrfToken:{type:"string",description:"CSRF token"}}}};exports.userRegisterSchema={type:"object",properties:{token:{type:"string",description:"Google OAuth token"},ref:{type:"string",description:"Referral code"}},required:["token"]};const returnUserWithTokens=async({user:e,message:r})=>{const s={id:e.id,role:e.roleId},{accessToken:t,refreshToken:o,csrfToken:a,sessionId:i}=await(0,token_1.generateTokens)(s);await(0,token_1.createSession)(s.id,s.role,t,a,o);return{message:r,cookies:{accessToken:t,sessionId:i,csrfToken:a}}};exports.returnUserWithTokens=returnUserWithTokens;exports.userInclude={include:[{model:db_1.models.role,as:"role",attributes:["id","name"],include:[{model:db_1.models.permission,as:"permissions",through:{attributes:[]}}]},{model:db_1.models.twoFactor,attributes:["type","enabled"]},{model:db_1.models.kycApplication,as:"kyc",attributes:["status","level"]},{model:db_1.models.author,attributes:["status"]}]};const sendEmailVerificationToken=async(e,r)=>{const s=await db_1.models.user.findOne({where:{email:r,id:e}});if(!s)throw(0,error_1.createError)({statusCode:404,message:"User not found"});const t=await(0,token_1.generateEmailCode)(s.id);try{await emails_1.emailQueue.add({emailData:{TO:s.email,FIRSTNAME:s.firstName,CREATED_AT:s.createdAt,TOKEN:t},emailType:"EmailVerification"});return{message:"Email with verification code sent successfully"}}catch(e){throw(0,error_1.createError)({message:e.message,statusCode:500})}};exports.sendEmailVerificationToken=sendEmailVerificationToken;const verifyResetTokenQuery=async e=>{const r=await(0,token_1.verifyResetToken)(e);if(!r||!r.sub)throw(0,error_1.createError)({statusCode:401,message:"Invalid or malformed token"});const s=await addOneTimeToken(r.jti,new Date);if(r.jti!==s)throw(0,error_1.createError)({statusCode:500,message:"Server error: Invalid JTI in the token"});try{if(!r.sub.id)throw(0,error_1.createError)({statusCode:401,message:"Malformed token: Missing sub.id"});await db_1.models.user.update({emailVerified:!0},{where:{id:r.sub.id}});return{message:"Token verified successfully"}}catch(e){throw(0,error_1.createError)({statusCode:500,message:`Server error: ${e.message}`})}};exports.verifyResetTokenQuery=verifyResetTokenQuery;const getUserByWalletAddress=async e=>{const r=await db_1.models.user.findOne({where:{walletAddress:e},include:exports.userInclude});if(r){const{password:e,...s}=r;return s}return null};exports.getUserByWalletAddress=getUserByWalletAddress;const ETH_ADDRESS_PATTERN=/0x[a-fA-F0-9]{40}/u,ETH_CHAIN_ID_IN_SIWE_PATTERN=/Chain ID: (?<temp1>\d+)/u;