"use strict";function sanitizeName(e){if("string"!=typeof e)return"";let r=e.replace(/<.*?>/g,"");r=r.replace(/[&<>"'/\\;:]/g,"");r=r.replace(/[^\p{L} \-'.]/gu,"");r=r.trim().slice(0,64);return r}Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const passwords_1=require("@b/utils/passwords"),db_1=require("@b/db"),affiliate_1=require("@b/utils/affiliate"),utils_1=require("../utils"),error_1=require("@b/utils/error"),console_1=require("@b/utils/console"),cache_1=require("@b/utils/cache"),pow_captcha_1=require("@b/utils/pow-captcha");exports.metadata={summary:"Registers a new user",operationId:"registerUser",tags:["Auth"],description:"Registers a new user and returns a session token",requiresAuth:!1,logModule:"REGISTER",logTitle:"User registration",requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{firstName:{type:"string",description:"First name of the user"},lastName:{type:"string",description:"Last name of the user"},email:{type:"string",format:"email",description:"Email of the user"},password:{type:"string",description:"Password of the user"},ref:{type:"string",description:"Referral code"},powSolution:{type:"object",description:"Proof-of-work solution if enabled",nullable:!0,properties:{challenge:{type:"string"},nonce:{type:"number"},hash:{type:"string"}}}},required:["firstName","lastName","email","password"]}}}},responses:{200:{description:"User registered successfully",content:{"application/json":{schema:{type:"object",properties:{message:{type:"string",description:"Success message"},cookies:{type:"object",properties:{accessToken:{type:"string",description:"Access token"},sessionId:{type:"string",description:"Session ID"},csrfToken:{type:"string",description:"CSRF token"}}}}}}}},400:{description:"Invalid request (e.g., email already in use)",content:{"application/json":{schema:{type:"object",properties:{message:{type:"string",description:"Error message"}}}}}}}};exports.default=async e=>{const{body:r,ctx:s}=e;let{firstName:t,lastName:i}=r;const{email:a,password:o,ref:n,powSolution:l}=r;try{null==s||s.step("Validating registration data");if(!(a&&o&&t&&i)){null==s||s.fail("Missing required registration fields");throw(0,error_1.createError)({statusCode:400,message:"All fields are required"})}null==s||s.step("Verifying security challenge");try{await(0,pow_captcha_1.verifyPowOrThrow)(l,"register")}catch(e){null==s||s.fail("Security verification failed");throw(0,error_1.createError)({statusCode:400,message:e instanceof Error?e.message:"Security verification failed"})}const e=cache_1.CacheManager.getInstance();null==s||s.step("Sanitizing user input");t=sanitizeName(t);i=sanitizeName(i);if(!t||!i){null==s||s.fail("Invalid name(s) after sanitization");throw(0,error_1.createError)({statusCode:400,message:"Invalid name(s)"})}null==s||s.step(`Checking if email ${a} is available`);const r=await db_1.models.user.findOne({where:{email:a}});if(r&&r.email){const t="true"===await e.getSetting("verifyEmailStatus");if(!r.emailVerified&&t){null==s||s.step("User exists but email not verified, resending verification");await(0,utils_1.sendEmailVerificationToken)(r.id,r.email);null==s||s.success("Verification email resent");return{message:"User already registered but email not verified. Verification email sent."}}null==s||s.fail("Email already in use");throw(0,error_1.createError)({statusCode:400,message:"Email already in use"})}null==s||s.step("Validating password policy");if(!(0,passwords_1.validatePassword)(o)){null==s||s.fail("Password does not meet requirements");throw(0,error_1.createError)({statusCode:400,message:"Invalid password format"})}null==s||s.step("Hashing password");const c=await(0,passwords_1.hashPassword)(o);null==s||s.step("Setting up user role");await db_1.models.role.upsert({name:"User"});const u="true"===process.env.NEXT_PUBLIC_DEMO_STATUS?"Admin":"User";await db_1.models.role.upsert({name:u});const d=await db_1.models.role.findOne({where:{name:u}});if(!d)throw(0,error_1.createError)({statusCode:500,message:"Role not found after upsert."});null==s||s.step("Creating new user account");const p=await db_1.models.user.create({firstName:t,lastName:i,email:a,password:c,roleId:d.id,emailVerified:!1,settings:{email:!0,sms:!1,push:!1}});if(!p.email){null==s||s.fail("Error creating user");throw(0,error_1.createError)({statusCode:500,message:"Error creating user"})}if(n){null==s||s.step(`Processing referral code: ${n}`);try{await(0,affiliate_1.handleReferralRegister)(n,p.id)}catch(e){null==s||s.step("Failed to process referral code","warn");console_1.logger.error("AUTH","Error handling referral registration",e)}}if("true"===await e.getSetting("verifyEmailStatus")){null==s||s.step("Sending email verification");await(0,utils_1.sendEmailVerificationToken)(p.id,p.email);null==s||s.success(`User ${a} registered, verification email sent`);return{message:"Registration successful, please verify your email"}}{null==s||s.step("Generating session tokens");const e=await(0,utils_1.returnUserWithTokens)({user:p,message:"You have been registered successfully"});null==s||s.success(`User ${a} registered and logged in`);return e}}catch(e){null==s||s.fail(e.message||"Registration failed");throw e}};